#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>

#ifndef __SPAD__
#define __CROSS_COMPILING_LINKER
#endif

#include <SPAD/LINK.H>

int total_read;

int h;

static void hard_read(void *p, int l)
{
	while (l) {
		int r = read(h, p, l);
		if (r < 0) perror("read"), exit(1);
		if (!r) fprintf(stderr, "can't read\n"), exit(1);
		total_read += r;
		p = (char *)p + r;
		l -= r;
	}
}

static int read_one(void)
{
	unsigned char c;
	int r = read(h, &c, 1);
	if (r == 1) return c;
	if (!r) return -1;
	perror("read"), exit(1);
	return -1;
}

static void skip_to(int l)
{
	char c[256];
	if (l < total_read) fprintf(stderr, "back skip\n"), exit(1);
	l -= total_read;
	while (l > 0) hard_read(c, l > 256 ? 256 : l), l -= 256;
}

static __f_off head_entry(struct link_header *head)
{
	__u8 *ptr = (__u8 *)head + JMP_BASE_OFFSET;
	return JMP_BASE_OFFSET + JMP_SIZE + ptr[1] + (ptr[2] << 8) + (ptr[3] << 16) + (ptr[4] << 24);
}

#define USAGE_INTMAP	1
#define USAGE_FAULTMAP	2
#define USAGE_BOOTSTRAP	3

int main(int argc, char *argv[])
{
	struct link_header head;
	__f_off entry;
	__f_off pos;
	unsigned char old_chr, chr;
	int usage;
	if (argc < 2 || argc > 3) {
		syn_err:
		fprintf(stderr, "Usage: DATADUMP /INTMAP|/FAULTMAP|/BOOTSTRAP [<input file>]\n");
		exit(3);
	}
	if (!strcasecmp(argv[1], "/INTMAP")) usage = USAGE_INTMAP;
	else if (!strcasecmp(argv[1], "/FAULTMAP")) usage = USAGE_FAULTMAP;
	else if (!strcasecmp(argv[1], "/BOOTSTRAP")) usage = USAGE_BOOTSTRAP;
	else {
		if (argc != 3) goto syn_err;
		if (!strcasecmp(argv[2], "/INTMAP")) usage = USAGE_INTMAP;
		else if (!strcasecmp(argv[2], "/FAULTMAP")) usage = USAGE_FAULTMAP;
		else if (!strcasecmp(argv[2], "/BOOTSTRAP")) usage = USAGE_BOOTSTRAP;
		else goto syn_err;
		if ((h = open(argv[1], O_RDONLY)) == -1) perror(argv[1]), exit(1);
		goto open_done;
	}
	h = 0;
	if (argc == 3 && (h = open(argv[2], O_RDONLY)) == -1) perror(argv[2]), exit(1);
	open_done:
	total_read = 0;
	if (usage == USAGE_INTMAP) {
		hard_read(&head, sizeof(head));
		entry = head_entry(&head);
		skip_to(entry);
		printf("\t.SECTION .rodata\n\t.GLOBAL INTERRUPT_MAP\n\t.ALIGN 16\nINTERRUPT_MAP:\n");
		pos = 0;
		old_chr = 0;
		do {
			__f_off next;
			hard_read(&next, sizeof(next));
			hard_read(&chr, sizeof(chr));
			if (next < pos) fprintf(stderr, "back seek\n"), exit(1);
			while (next > pos) printf("\t.BYTE\t%d\n", (int)old_chr), pos++;
		} while ((old_chr = chr) != 0x80);
	} else if (usage == USAGE_FAULTMAP) {
		hard_read(&head, sizeof(head));
		entry = head_entry(&head);
		skip_to(entry);
		printf("\t.SECTION .rodata\n\t.GLOBAL PAGEFAULT_MAP\n\t.ALIGN 16\nPAGEFAULT_MAP:\n");
		pos = 0;
		while (1) {
			__f_off next;
			__f_off val;
			hard_read(&next, sizeof(next));
			hard_read(&val, sizeof(val));
			/*fprintf(stderr, "%x, %x\n", next, val);*/
			/*fprintf(stderr, "skip: %d\n", next - pos);*/
			if (next < pos) fprintf(stderr, "back seek\n"), exit(1);
			if (val == 0x80000000) break;
			while (pos < next) {
				printf("\t.LONG\t0\n");
				pos++;
			}
			if (!val) fprintf(stderr, "fault to itself at %lx\n", (unsigned long)next), exit(1);
			printf("\t.LONG\tKERNEL_CRAWLOUT_SPACE + 0x%04lX\n", (unsigned long)(next + val));
			pos = next + 1;
		}
		printf("\t.GLOBAL PAGEFAULT_MAP_LEN\nPAGEFAULT_MAP_LEN = 0x%04lX\n", (unsigned long)pos);
	} else if (usage == USAGE_BOOTSTRAP) {
		int x;
		printf("\t.SECTION .rodata\n\t.GLOBAL BOOTSTRAP_START\n\t.GLOBAL BOOTSTRAP_END\n\t.ALIGN 64\nBOOTSTRAP_START:\n");
		while ((x = read_one()) != -1) printf("\t.BYTE\t %d\n", x);
		printf("BOOTSTRAP_END:\n");
	}
	if (argc == 3) close(h);
	return 0;
}
