#define GOTPLT_ENTRY_SIZE	12

static void arch_insert_gotplt_entry(struct link_symbol *ls)
{
	struct patch *pt;
	char *e;
	got.align = 4;
	got.contents = x_realloc(got.contents, got.size + GOTPLT_ENTRY_SIZE);
	e = (char *)got.contents + got.size;
	memset(e, 0, GOTPLT_ENTRY_SIZE);
	e[4] = 0xe9;
	e[5] = 0xfc;
	e[6] = 0xff;
	e[7] = 0xff;
	e[8] = 0xff;
	ls->ssect_off = got.size;
	pt = x_malloc(sizeof(struct patch));
	pt->sec = &got;
	pt->special_offset = 0;
	pt->address = got.size;
	pt->howto_pcrel_offset = 0;
	pt->sym_name = ls->name;
	pt->symbol = NULL;
	ADD_TO_LIST_END(&unresolved_patches, &pt->u);
	ADD_TO_LIST_END(&patches, &pt->e);
	pt = x_malloc(sizeof(struct patch));
	pt->sec = &got;
	pt->special_offset = 0;
	pt->address = got.size + 5;
	pt->howto_pcrel_offset = REL_PC;
	pt->sym_name = ls->name;
	pt->symbol = NULL;
	ADD_TO_LIST_END(&unresolved_patches, &pt->u);
	ADD_TO_LIST_END(&patches, &pt->e);
	got.size += GOTPLT_ENTRY_SIZE;
}

static __f_off arch_get_gotplt_offset(struct link_symbol *ls, int plt)
{
	return ls->ssect_off + (plt ? 4 : 0);
}
