#include <ARCH/IO.H>
#include <KERNEL/VM.H>
#include <ARCH/BIOS16.H>

void RESET(void)
{
	KERNEL$DI();
	*(__u16 *)(KERNEL$ZERO_BANK + 0x472) = 0x1234;
	__critical_printf("RESETTING");
	while (1) {
		unsigned i;
		for (i = 0; i < 100000; i++) {
			if (!(io_inb(0x62) & 0x02)) break;
			KERNEL$UDELAY(2);
		}
		KERNEL$UDELAY(50);
		io_outb(0x64, 0xfe);
		KERNEL$UDELAY(50);
	}
}

void HALT(void)
{
	KERNEL$DI();
	__critical_printf("SYSTEM HALTED");
	io_outb(0x80, 0x01);
	while (1) __asm__ volatile ("HLT":::"memory");
}

void POWEROFF(void)
{
	struct bios_regs regs;
	memset(&regs, 0, sizeof regs);
	regs.eax = 0x5300;
	BIOS16$REAL_INT(0x15, &regs, NULL, 0, 0);
	if ((regs.ebx & 0xffff) != 0x504d) {
		HALT();
		return;
	}
	/*__debug_printf("apm: %x %x\n", regs.eax, regs.ecx);*/
	memset(&regs, 0, sizeof regs);
	regs.eax = 0x5304;
	BIOS16$REAL_INT(0x15, &regs, NULL, 0, 0);
	/*__debug_printf("apm: %x %x\n", regs.eax, regs.ecx);*/
	memset(&regs, 0, sizeof regs);
	regs.eax = 0x5301;
	BIOS16$REAL_INT(0x15, &regs, NULL, 0, 0);
	/*__debug_printf("apm: %x %x\n", regs.eax, regs.ecx);*/
	__critical_printf("POWEROFF");
	memset(&regs, 0, sizeof regs);
	regs.eax = 0x5307;
	regs.ebx = 0x0001;
	regs.ecx = 0x0003;
	BIOS16$REAL_INT(0x15, &regs, NULL, 0, 0);
	/*__debug_printf("apm: %x %x\n", regs.eax, regs.ecx);*/
	io_outb(0x80, 0x02);
	while (1) ;
}
