#include <DOC.H>

$DOC_INTERFACE(BIOS16$REAL_INT,

$TYPE_INLINE_FUNCTION

$ENVIRONMENT(User/kernel, Sync/async, No, Any, No)

$INCLUDES(
$INCLUDE(ARCH/BIOS16.H)
)

$FORMAT(int BIOS16$REAL_INT(int $ARG(intnum), $LINK(STRUCT_BIOS_REGS,struct
bios_regs) *$ARG(regs), void *$ARG(ptr), unsigned $ARG(len), int $ARG(flags));)

$DESCRIPTION(
This function calls BIOS interrupt in 16-bit real mode. After that it switches
back to protected more and returns the resulting registers.
$NP
Optionally, this function can copy any data to or from real mode. The data are
copied to or from any protected mode address to an address $CODE(BIOS_PTR_BASE).
If you need to copy data, set up registers as if data were at
$CODE(BIOS_PTR_BASE) and pass data pointer and length to $ARG(ptr) and
$ARG(len).
$NP
This function must be called with enabled interrupts. It may be called with
disabled interrupts only in crash-handling code (but in that case it won't allow
interrupts to be enabled ever more).
$NP
This function should not be called often, because it inhibits all interrupts
during the time of call.
)

$ARGUMENTS(
$ARGUMENT(intnum, The interrupt to call: 0 $NDASH 255)
$ARGUMENT(regs, Registers to pass to the interrupt. On return, resulting
registers are returned in this.)
$ARGUMENT(ptr, Pointer to data that should be copied to or from real mode.)
$ARGUMENT(len, Length of data that should be copied to or from real mode. It
must be at most $CODE(BIOS_MAX_LEN).)
$ARGUMENT(flags, One of these constants:
$CONSTANTS(
$CONSTANT(0, Do not transfer any data)
$CONSTANT(BIOS_DATA_PUT, Copy data to real mode)
$CONSTANT(BIOS_DATA_GET, Copy data from real mode)
$CONSTANT(BIOS_DATA_PUT_GET, Copy data to real mode and after a call to BIOS,
copy them back to protected mode)
)
)
)

$RETURNS(Zero on success. Negative error code on error.)


$SEE_ALSO($LINK(STRUCT_BIOS_REGS, struct bios_regs))

)

$IGNORE(
vim: textwidth=80
)
