#include <DOC.H>

$DOC_INTERFACE(CALL_IORQ,

$TYPE_MACRO_COMMAND

$ENVIRONMENT(User/kernel, Sync/async, No, Any, No)

$INCLUDES(
$INCLUDE(SPAD/AC.H)
)

$FORMAT(CALL_IORQ($ARG(iorq), $ARG(handler));)

$DESCRIPTION(
This is a preprocessor macro that expands to machine- and compiler-dependent
code to call an IORQ. If the current $LINK(KERNEL$SPL, SPL) is lower than IORQ
handler's SPL, the handler is executed immediatelly,
otherwise the IORQ is queued. IORQ posted with this function may be canceled
with $LINK(KERNEL$CIO,KERNEL$CIO) function, however, after cancel, the caller
must still wait for AST to arrive. After the AST arrives, he may free or reuse
the structure.
)

$ARGUMENTS(
$ARGUMENT(iorq,
Pointer to structure $LINK(IORQ,IORQ) (or any structure that begins with
$LINK(IORQ_HEAD,IORQ_HEAD)) that will be called. The structure must
have valid entry $CODE(fn) pointing to AST function declared with
$LINK(DECL_AST,DECL_AST). When the AST is called, status of the request is
reported in $ARG(iorq)'s $CODE(status) field. All the fields (except $CODE(fn))
may change while the IORQ is being executed.
)
$ARGUMENT(handler,
A function declared with $LINK(DECL_IOCALL,DECL_IOCALL). It must not be a
pointer (if you need a handler specified with pointer, use
$LINK(CALL_IORQ_EXPR,CALL_IORQ_EXPR)$).
)
)

$IMPLEMENTATION(IORQs on the same SPL are called in the same order they were
queued, but the programmer must not depend on it for correctness. The programmer
may
depend on this feature for good performance (for example networking packets are
queued with this call $MDASH the protocols are required to handle out-of-order
packets correctly, altough it causes performance degradation).)

$SEE_ALSO($LINK(DECL_AST, DECL_AST), $LINK(DECL_IOCALL, DECL_IOCALL),
$LINK(CALL_IORQ_EXPR, CALL_IORQ_EXPR),
$LINK(KERNEL$SPL, KERNEL$SPL))

)

$IGNORE(
vim: textwidth=80
)
