#include <DOC.H>

$DOC_INTERFACE(CALL_IORQ_CANCELABLE,

$TYPE_MACRO_COMMAND

$ENVIRONMENT(User/kernel, Sync/async, No, Any, No)

$INCLUDES(
$INCLUDE(SPAD/AC.H)
)

$FORMAT(CALL_IORQ_CANCELABLE($ARG(iorq), $ARG(handler), $ARG(chained_iorq));)

$DESCRIPTION(
This is a preprocessor macro that expands to machine- and compiler-dependent
code to call an IORQ. The functionality is similar to $LINK(CALL_IORQ,CALL_IORQ)
except that $CODE(CALL_IORQ_CANCELABLE) links the $ARG(iorq) to already posted
$ARG(chained_iorq) $MDASH when cancel on $ARG(chained_iorq) is attempted,
$ARG(iorq) is also canceled.

$NP

An AST for this $ARG(iorq) MUST perform
$LINK(IO_DISABLE_CHAIN_CANCEL,IO_DISABLE_CHAIN_CANCEL) on $ARG(chained_iorq)
$MDASH before it frees or reuses $ARG(iorq) (It is good practice to call
$CODE(IO_DISABLE_CHAIN_CANCEL) as the first command in the AST).
$CODE(IO_DISABLE_CHAIN_CANCEL) will unlink $ARG(iorq) from $ARG(chained_iorq),
if it were not called there would be dangling pointer to uninitialized memory
space.

$NP

If $ARG(chained_iorq) has already pending cancel, $CODE(CALL_IORQ_CANCELABLE)
won't call $ARG(handler) at all and will instead post $ARG(iorq)'s AST with
status $CODE(-EINTR).

)

$ARGUMENTS(
$ARGUMENT(iorq,
Pointer to structure $LINK(IORQ,IORQ) (or any structure that begins with
$LINK(IORQ_HEAD,IORQ_HEAD)) that will be called. The structure must
have valid entry $CODE(fn) pointing to AST function declared with
$LINK(DECL_AST,DECL_AST). The AST function must call
$LINK(IO_DISABLE_CHAIN_CANCEL,IO_DISABLE_CHAIN_CANCEL) on $ARG(chained_iorq).
)
$ARGUMENT(handler,
A function declared with $LINK(DECL_IOCALL,DECL_IOCALL). It must not be a
pointer (if you need a handler specified with pointer, use
$LINK(CALL_IORQ_CANCELABLE_EXPR,CALL_IORQ_CANCELABLE_EXPR)$).
)
$ARGUMENT(chained_iorq,
An IORQ that has been already posted with $LINK(CALL_IORQ,CALL_IORQ) or similar
macro, but was not yet returned with $LINK(CALL_AST,CALL_AST) or
$LINK(RETURN_AST,RETURN_AST).
)
)

$EXAMPLE(
$CODE(
IORQ *r;$NL
SIORQ s;$NL
char string[80];
$NP
DECL_IOCALL(FUNCTION, SPL_DEV, IORQ)$NL
{$NL
$TAB()r = RQ;$NL
$TAB()s.v.ptr = (unsigned long)string;$NL
$TAB()s.v.len = sizeof string;$NL
$TAB()s.v.vspace = KERNEL$VIRTUAL;$NL
$TAB()s.h = 0;$NL
$TAB()s.progress = 0;$NL
$TAB()s.fn = READ_CHARS;$NL
$TAB()CALL_IORQ_CANCELABLE(s, KERNEL$READ);$NL
$TAB()RETURN;$NL
}$NL
$NP
DECL_AST(READ_CHARS, SPL_DEV, AST)$NL
{$NL
$TAB()IO_DISABLE_CHAIN_CANCEL(SPL_DEV, r);$NL
$TAB()if (RQ->status == -EINTR) {$NL
$TAB()$TAB()r->status = -EINTR;$NL
$TAB()$TAB()RETURN_AST(r);$NL
$TAB()}$NL
$TAB()... more code ...$NL
}
)

$NP

We declare an IORQ handler $CODE(FUNCTION) that calls another IORQ to read data
from handle 0 (terminal). When the IORQ passed to $CODE(FUNCTION) is canceled,
reading of data from
the terminal is canceled too and returns $CODE(-EINTR). Our AST
$CODE(READ_CHARS) checks this condition and return $CODE(-EINTR) to the
IORQ in this case.
$NL
Note that because we use
global variables, there may not be more $CODE(FUNCTION) requests posted
concurrently.

)

$SEE_ALSO($LINK(CALL_IORQ, CALL_IORQ), $LINK(DECL_IOCALL, DECL_IOCALL),
$LINK(DECL_AST, DECL_AST),
$LINK(IO_DISABLE_CHAIN_CANCEL, IO_DISABLE_CHAIN_CANCEL))

)

$IGNORE(
vim: textwidth=80
)
