#include <DOC.H>

$DOC_INTERFACE(GET_STRUCT,

$TYPE_MACRO_EXPRESSION

$ENVIRONMENT(User/kernel, Sync/async/rt-irq, No, Any, No)

$INCLUDES(
$INCLUDE(SPAD/AC.H)
)

$FORMAT(p = GET_STRUCT($ARG(ptr), $ARG(type), $ARG(member));)

$DESCRIPTION(
This macro converts a pointer to the member of a structure to a pointer to the
structure.
$NP
This macro is often used in ASTs $MDASH in AST handler we receive a pointer to
the AST being posted and we need a pointer to the structure containing the
AST. $CODE(GET_STRUCT) is usually one of the first commands in the AST handler.
)

$ARGUMENTS(
$ARGUMENT(ptr,
Pointer to the member of a structure.
)
$ARGUMENT(type,
The structure type. $ARG(ptr) points to a member of this type.
)
$ARGUMENT(member,
Member name. This is one member of the structure $ARG(type).
)
)

$RETURNS(
Pointer to the whole structure.
)

$SEE_ALSO($LINK(LIST_STRUCT,LIST_STRUCT))

)

$IGNORE(
vim: textwidth=80
)
