#include <DOC.H>

$DOC_INTERFACE(IO_DISABLE_CHAIN_CANCEL,

$TYPE_MACRO_COMMAND

$ENVIRONMENT(User/kernel, Async, No, Any, No)

$INCLUDES(
$INCLUDE(SPAD/AC.H)
)

$FORMAT(IO_ENABLE_KERNEL_CANCEL($ARG(spl), $ARG(iorq));)

$DESCRIPTION(
This macro unlinks any IO requests chained on $ARG(iorq). It is called in an AST
of a request that was posted with
$LINK(CALL_IORQ_CANCELABLE,CALL_IORQ_CANCELABLE)
or $LINK(RETURN_IORQ_CANCELABLE,RETURN_IORQ_CANCELABLE). See definition of
$LINK(CALL_IORQ_CANCELABLE,CALL_IORQ_CANCELABLE) for usage specification and for
an example.
)

$ARGUMENTS(
$ARGUMENT(spl,
This must be equal to the current SPL.
)
$ARGUMENT(iorq,
Pointer to structure $LINK(IORQ,IORQ) (or any structure that begins with
$LINK(IORQ_HEAD,IORQ_HEAD)) that was passed to
$LINK(CALL_IORQ_CANCELABLE,CALL_IORQ_CANCELABLE) or
$LINK(RETURN_IORQ_CANCELABLE,RETURN_IORQ_CANCELABLE) as a $CODE(chained_iorq)
argument.
)
)

$SEE_ALSO($LINK(CALL_IORQ_CANCELABLE, CALL_IORQ_CANCELABLE),
$LINK(RETURN_IORQ_CANCELABLE, RETURN_IORQ_CANCELABLE))

)

$IGNORE(
vim: textwidth=80
)
