#include <DOC.H>

$DOC_INTERFACE(KERNEL$SPL,

$TYPE_VARIABLE

$ENVIRONMENT(User/kernel, Sync/async, No, Any, No)

$INCLUDES(
$INCLUDE(SPAD/AC.H)
)

$FORMAT(extern int KERNEL$SPL;)

$DESCRIPTION(
This variable contains the current SPL in internal SPL format (as returned by
$CODE(SPL_X)). The variable can be read to obtain the current SPL in code that
is supposed to run at multiple SPLs.
$NL
This variable must not be directly written (except special cases of
crash-dumping code $MDASH where specified). Instead, SPL is modified with
macros $CODE(RAISE_SPL) and $CODE(LOWER_SPL).
)

$EXAMPLE($CODE(
int spl = KERNEL$SPL;$NL
RAISE_SPL(SPL_TOP);$NL
... code to be masked $NL
LOWER_SPLX(spl);$NL
))

$SEE_ALSO($LINK(RAISE_SPL, RAISE_SPL), $LINK(LOWER_SPL, LOWER_SPL),
$LINK(SPL_X, SPL_X))

)

$IGNORE(
vim: textwidth=80
)
