#include <DOC.H>

$DOC_INTERFACE(LOWER_SPL,

$TYPE_MACRO_COMMAND

$ENVIRONMENT(User/kernel, Sync/async, No, Any, No)

$INCLUDES(
$INCLUDE(SPAD/AC.H)
)

$FORMAT(LOWER_SPL($ARG(spl)))

$DESCRIPTION(
This is the equivalent of
$CODE($LINK(LOWER_SPLX,LOWER_SPLX)($LINK(SPL_X,SPL_X)(spl))). See definition of
these macros.
)

$ARGUMENTS(
$ARGUMENT(splx,
This must be valid internal SPL, as obtained from $CODE(SPL_X) or
by other means (reading $CODE(KERNEL$SPL)).
)
)

$ARGUMENTS(
$ARGUMENT(spl,
A constant number in the range 0 $NDASH 30. It must be lower or equal than
current SPL.
)
)

$IMPLEMENTATION(The macro performs a
compile-time check for correct argument.
$NP
When $LINK(__DEBUG,__DEBUG) is $GT()= 2, the macro performs a
check if current SPL is higher or equal than new SPL.
)

$SEE_ALSO($LINK(SPL_X, SPL_X),
$LINK(LOWER_SPLX, LOWER_SPLX))

)

$IGNORE(
vim: textwidth=80
)
