#include <DOC.H>

$DOC_INTERFACE(RAISE_SPLX,

$TYPE_MACRO_COMMAND

$ENVIRONMENT(User/kernel, Sync/async, No, Any, No)

$INCLUDES(
$INCLUDE(SPAD/AC.H)
)

$FORMAT(RAISE_SPLX($ARG(splx)))

$DESCRIPTION(
Raises SPL to a given value. $ARG(splx) must be higher or equal than current SPL
($LINK(KERNEL$SPL,KERNEL$SPL)). This macro issues a proper compiler
memory-barrier, so that the compiler doesn't try to reorder code around
SPL-raising instruction.
)

$ARGUMENTS(
$ARGUMENT(splx,
This must be valid internal SPL, as obtained from $CODE(SPL_X) or
by other means (reading $CODE(KERNEL$SPL)). It must be higher or equal than
current SPL.
)
)

$IMPLEMENTATION(When $LINK(__DEBUG,__DEBUG) is $GT()= 2, the macro performs a
check if current SPL is lower or equal than new SPL. It also performs a check if
the argument is correct.
)

$SEE_ALSO($LINK(LOWER_SPL, LOWER_SPL), $LINK(LOWER_SPLX, LOWER_SPLX),
$LINK(RAISE_SPL, RAISE_SPL)
$LINK(SPL_X, SPL_X))

)

$IGNORE(
vim: textwidth=80
)
