#include <DOC.H>

$DOC_INTERFACE(RETURN_IORQ,

$TYPE_MACRO_COMMAND

$ENVIRONMENT(User/kernel, Async, No, Higher or equal than SPL of AST or IORQ, No)

$INCLUDES(
$INCLUDE(SPAD/AC.H)
)

$FORMAT(RETURN_IORQ($ARG(iorq), $ARG(handler));)

$DESCRIPTION(
The behavior of $CODE(RETURN_IORQ($ARG(iorq), $ARG(handler))) is equivalent to
$NL $CODE($LINK(CALL_IORQ, CALL_IORQ)($ARG(iorq), $ARG(handler)));$NL
$CODE($LINK(RETURN, RETURN);$NL)
$CODE(RETURN_IORQ) is faster than the above sequence, because in most cases IORQ
doesn't have to be queued and then extracted from the queue.
)

$ARGUMENTS(
$ARGUMENT(iorq, See arguments in $LINKTAG(CALL_IORQ, ARGTAG, CALL_IORQ))
$ARGUMENT(handler, Handler is the function to be called. It may be even function
declared with $LINK(DECL_IOCALL,DECL_IOCALL) or a pointer to
$LINK(IO_STUB,IO_STUB).)
)

$IMPLEMENTATION(
There is slight difference between $LINK(CALL_IORQ, CALL_IORQ); $LINK(RETURN,
RETURN) and $CODE(RETURN_IORQ): $LINK(CALL_IORQ, CALL_IORQ) and $LINK(RETURN,
RETURN) queue the IORQ after all ASTs and IORQs on a given SPL, but
$CODE(RETURN_IORQ) executes the IORQ directly, jumping the queue. Because order
of executing ASTs and IORQs is not defined, code must be written in such a way
that this difference doesn't change behavior.
)

$SEE_ALSO($LINK(CALL_IORQ, CALL_IORQ), $LINK(RETURN, RETURN), $LINK(DECL_IOCALL,
DECL_IOCALL))

)

$IGNORE(
vim: textwidth=80
)
