#include <DOC.H>

$DOC_INTERFACE(RETURN_IORQ_CANCELABLE,

$TYPE_MACRO_COMMAND

$ENVIRONMENT(User/kernel, Async, No, Higher or equal than SPL of AST or IORQ, No)

$INCLUDES(
$INCLUDE(SPAD/AC.H)
)

$FORMAT(RETURN_IORQ_CANCELABLE($ARG(iorq), $ARG(handler), $ARG(chained_iorq));)

$DESCRIPTION(
The behavior of $CODE(RETURN_IORQ_CANCELABLE($ARG(iorq), $ARG(handler),
$ARG(chained_iorq))) is equivalent to $NL
$CODE($LINK(CALL_IORQ_CANCELABLE, CALL_IORQ_CANCELABLE)($ARG(iorq),
$ARG(handler), $ARG(chained_iorq)));$NL
$CODE($LINK(RETURN, RETURN);$NL)
$CODE(RETURN_IORQ_CANCELABLE) is faster than the above sequence, because in most
cases IORQ doesn't have to be queued and then extracted from the queue.
)

$ARGUMENTS(
$ARGUMENT(iorq, See arguments in $LINKTAG(CALL_IORQ_CANCELABLE, ARGTAG,
CALL_IORQ_CANCELABLE).)
$ARGUMENT(handler, Handler is the function to be called. It may be even function
declared with $LINK(DECL_IOCALL,DECL_IOCALL) or a pointer to
$LINK(IO_STUB,IO_STUB).)
$ARGUMENT(chained_iorq, See arguments and requirements in
$LINK(CALL_IORQ_CANCELABLE, CALL_IORQ_CANCELABLE))
)

$IMPLEMENTATION(
There is slight difference between $LINK(CALL_IORQ_CANCELABLE,
CALL_IORQ_CANCELABLE);
$LINK(RETURN,
RETURN) and $CODE(RETURN_IORQ_CANCELABLE): $LINK(CALL_IORQ_CANCELABLE,
CALL_IORQ_CANCELABLE)
and $LINK(RETURN,
RETURN) queue the IORQ after all ASTs and IORQs on a given SPL, but
$CODE(RETURN_IORQ_CANCELABLE) executes the IORQ directly, jumping the queue.
Because order
of executing ASTs and IORQs is not defined, code must be written in such a way
that this difference doesn't change behavior.
)

$SEE_ALSO($LINK(CALL_IORQ_CANCELABLE, CALL_IORQ_CANCELABLE), $LINK(RETURN, RETURN))

)

$IGNORE(
vim: textwidth=80
)
