#include <DOC.H>

$DOC_INTERFACE(SPLX_BELOW,

$TYPE_MACRO_EXPRESSION

$ENVIRONMENT(User/kernel, Sync/async/rt-irq, No, Any, No)

$INCLUDES(
$INCLUDE(SPAD/AC.H)
)

$FORMAT(if (SPLX_BELOW($ARG(splx1), $ARG(splx2))) ...)

$DESCRIPTION(
This macro compares two SPL levels specified in internal SPL format (as returned
by $CODE(SPL_X)). It returns non-zero if $ARG(splx1) is lower than $ARG(SPL2).
Because
the internal format is not specified (it's architecture-specific), they can't be
compared with operators $LT() or $GT().
)

$ARGUMENTS(
$ARGUMENT(splx1,
The first SPL. This must be valid internal SPL, as obtained from $CODE(SPL_X) or
by other means (reading $CODE(KERNEL$SPL)).
)
$ARGUMENT(splx2,
The second SPL. This must be valid internal SPL, as obtained from $CODE(SPL_X)
or by other means (reading $CODE(KERNEL$SPL)).
)
)

$RETURNS(
Returns non-zero if $ARG(splx1) is below $ARG(splx2).
)

$IMPLEMENTATION(If one of the arguments is constant, the macro performs a
compile-time check for correctness.
)

$EXAMPLE($CODE(
if (SPLX_BELOW(SPL_X(SPL_DEV), KERNEL$SPL))$NL
$TAB()KERNEL$SUICIDE("FUNCTION CALLED AT BAD SPL: %08X", KERNEL$SPL);$NL
RAISE_SPL(SPL_DEV);$NL
))

$SEE_ALSO($LINK(SPL_X, SPL_X),
$LINK(KERNEL$SPL, KERNEL$SPL))

)

$IGNORE(
vim: textwidth=80
)
