#include <DOC.H>

$DOC_INTERFACE(SPLX_BUSY,

$TYPE_MACRO_EXPRESSION

$ENVIRONMENT(User/kernel, Sync/async, No, Any, No)

$INCLUDES(
$INCLUDE(SPAD/AC.H)
)

$FORMAT(if (SPLX_BUSY($ARG(splx))) ...)

$DESCRIPTION(
This macro tests if there is some event pending on SPL $ARG(splx) or higher. If
there is, it returns nonzero. If there isn't, it returns zero.
)

$ARGUMENTS(
$ARGUMENT(splx,
This must be valid internal SPL, as obtained from $CODE(SPL_X) or
by other means (reading $CODE(KERNEL$SPL)).
)
)

$RETURNS(
Returns non-zero if there is an AST or IORQ pending on or above $ARG(splx).
)

$IMPLEMENTATION(If the argument is constant, the macro performs a
compile-time check for correctness.
)

$EXAMPLE(
To maintain good interrupt latency, there must not be any loop on
$CODE(SPL_TOP). If we need to make a loop there, we must test inside the loop if
some interrupt interrupted us and eventually drop the SPL. This is an example
how to do it with $CODE(SPLX_BUSY).
$NP
$CODE(
int spl = KERNEL$SPL;$NL
RAISE_SPL(SPL_TOP);$NL
while (condition) {$NL
$TAB()... do something locked $NL
$TAB()if (SPLX_BUSY(spl)) {$NL
$TAB()$TAB()... prepare for unlock $NL
$TAB()$TAB()TEST_SPLX(spl, SPL_X(SPL_TOP));$NL
$TAB()$TAB()... check after locking $NL
$TAB()}$NL
}$NL
LOWER_SPLX(spl)$NL
))

$SEE_ALSO($LINK(SPL_X, SPL_X),
$LINK(KERNEL$SPL, KERNEL$SPL), $LINK(TEST_SPL, TEST_SPL), $LINK(TEST_SPLX,
TEST_SPLX))

)

$IGNORE(
vim: textwidth=80
)
