#include <DOC.H>

$DOC_INTERFACE(SPLX_MIN,

$TYPE_MACRO_EXPRESSION

$ENVIRONMENT(User/kernel, Sync/async/rt-irq, No, Any, No)

$INCLUDES(
$INCLUDE(SPAD/AC.H)
)

$FORMAT(int x = SPLX_MIN($ARG(splx1), $ARG(splx2)) ...)

$DESCRIPTION(
Returns the lower of the two SPLs. Because
the internal format is not specified (it's architecture-specific), they can't be
compared with operators $LT() or $GT().
)

$ARGUMENTS(
$ARGUMENT(splx1,
The first SPL. This must be valid internal SPL, as obtained from $CODE(SPL_X) or
by other means (reading $CODE(KERNEL$SPL)).
)
$ARGUMENT(splx2,
The second SPL. This must be valid internal SPL, as obtained from $CODE(SPL_X)
or by other means (reading $CODE(KERNEL$SPL)).
)
)

$RETURNS(
An integer number representing the lower SPL of its two arguments. The return
value is in the internal SPL format.
)

$IMPLEMENTATION(If one of the arguments is constant, the macro performs a
compile-time check for correctness.
)

$SEE_ALSO($LINK(SPLX_BELOW, SPLX_BELOW),
$LINK(SPLX_MAX, SPLX_MAX))

)

$IGNORE(
vim: textwidth=80
)
