#include <DOC.H>

$DOC_INTERFACE(SPL_X,

$TYPE_MACRO_EXPRESSION

$ENVIRONMENT(User/kernel, Sync/async/rt-irq, No, Any, No)

$INCLUDES(
$INCLUDE(SPAD/AC.H)
)

$FORMAT(x = SPL_X($ARG(spl));)

$DESCRIPTION(
This macro converts portable SPL number (in range 0 $NDASH 30) to internal
architecture-specific SPL representation.

)

$ARGUMENTS(
$ARGUMENT(spl,
A number in the range 0 $NDASH 30. This argument must be constant.
$NP

It is good practice to pass costants defined in $FILE(SPAD/SPLDEF.H), so that
SPLs of all components can be changed in one file.

)
)

$RETURNS(
This macro returns internal SPL definition that can be further passed to SPL
functions and macros having X suffix. The internal SPL definition fits into
$CODE(int) type.
)

$IMPLEMENTATION(The macro tests at compile-time if the argument is valid.
$NP
On IA-32, the this macro is defined as $CODE(-1 << (spl + 1)). On other
architectures, the internal format may be defined differently, accoring to the
availability and speed of bit-manipulation functions.
)

$SEE_ALSO($LINK(RAISE_SPLX, RAISE_SPLX), $LINK(LOWER_SPLX, LOWER_SPLX),
$LINK(KERNEL$SPL, KERNEL$SPL))

)

$IGNORE(
vim: textwidth=80
)
