#include <DOC.H>

$DOC_INTERFACE(__ALIGN_ATTR__,

$TYPE_MACRO_TYPE_ATTRIBUTE

$INCLUDES(
$INCLUDE(SYS/TYPES.H)
)

$FORMAT(type variable __ALIGN_ATTR__($ARG(a));)

$DESCRIPTION(
This macro advises the compiler to align a given variable or structure element
on a given boundary.
$NP
Because the code may be compiled with compiler not supporting this attribute,
code correctness must not depend on alignment $MDASH it may be only used for
optimizations such as preventing variables from crossing cache line boundary.
$NP
If the alignment is required for code correctness, use $LINK(MEMALIGN, memalign)
or allocate larger array, cast array address to $CODE(unsigned long) and align
it with arithmetic operators.
)

$ARGUMENTS(
$ARGUMENT(a, An integer value to align to. It must be power of 2.)
)

$IMPLEMENTATION(When using the gcc compiler, this macro expands to
$CODE(__attribute__((__aligned__($ARG(a))))).
)

)

$IGNORE(
vim: textwidth=80
)
