#include <DOC.H>

$DOC_INTERFACE(__barrier,

$TYPE_INLINE_FUNCTION

$ENVIRONMENT(User/kernel, Sync/async, No, Any, No)

$INCLUDES(
$INCLUDE(SPAD/BARRIER.H)
)

$FORMAT(static $LINK(__FINLINE__,__finline__) void __barrier(void);)

$DESCRIPTION(
This function prevents reordering of instructions by the compiler. So that any
AST or interrupt that interrupts the current code sequence will see ordered
state $MDASH when it sees any of the assignments following $CODE(__barrier()),
it can expects that all the assignments preceding $CODE(__barrier()) have
completed.
$NP
$CODE(__barrier()) doesn't protect against reordering of instructions within the
CPU itself.
)

$SEE_ALSO($LINK(__BARRIER_PTR, __barrier_ptr))

)

$IGNORE(
vim: textwidth=80
)
