#include <DOC.H>

$DOC_INTERFACE(__barrier_ptr,

$TYPE_INLINE_FUNCTION

$ENVIRONMENT(User/kernel, Sync/async, No, Any, No)

$INCLUDES(
$INCLUDE(SPAD/BARRIER_PTR.H)
)

$FORMAT(static $LINK(__FINLINE__,__finline__) void __barrier_ptr(void
*$ARG(p));)

$DESCRIPTION(
This function has the same effect as $LINK(__BARRIER,__barrier) and additionally
it invalidates optimizations pointer $ARG(p). The purpose of this function is to
defeat aliasing optimizations in C99.
)

$ARGUMENTS(
$ARGUMENT(p,
The pointer on which optimizations should be avoided.
)
)

$EXAMPLE($CODE(
__u32 p;$NL
__u16 q;$NL
p = 0x12345678;$NL
__barrier_ptr(&p);$NL
q = *(__u16 *)p;
)
$NP
Note that without $CODE(__barrier_ptr) the compiler can reorder these two
assignments according to C99, because they touch memory with different types.
$NP
C99 has special exception for $CODE(char) types. If one of these types were
$CODE(char), $LINK(__U8, __u8) or $LINK(__S8, __s8), $CODE(__barrier_ptr) would
be unnecessary.
)

$SEE_ALSO($LINK(__BARRIER, __barrier))

)

$IGNORE(
vim: textwidth=80
)
