#include <DOC.H>

$DOC_INTERFACE(__BC,

$TYPE_INLINE_FUNCTION

$ENVIRONMENT(User/kernel, Sync/async/rt-irq, No, Any, No)

$INCLUDES(
$INCLUDE(ARCH/BT.H)
)

$FORMAT(static $LINK(__FINLINE__,__finline__) void
__BC(void *$ARG(ptr), int $ARG(bit));)

$DESCRIPTION(
Negates a bit in a memory bitmap. Atomicity of this operation
is not specified $MDASH it should not be performed simultaneously by more
threads or simultaneously by a code and an AST that interrupts it.
$NP
See the definition of $LINK(__BT,__BT) for description of the bitmap format in
memory.
)

$ARGUMENTS(
$ARGUMENT(ptr, Pointer to a memory bitmap. It must have size at least
$CODE(sizeof(long) * (($ARG(bit) + (sizeof(long) * 8 - 1)) / sizeof(long) / 8))
bytes.
)
$ARGUMENT(bit, A bit in the bitmap. This must be positive number.)
)

$SEE_ALSO(
$LINK(__BT,__BT),
$LINK(__BTS,__BTS),
$LINK(__BTR,__BTR),
$LINK(__BTC,__BTC)
$LINK(__BS,__BS),
$LINK(__BR,__BR),
)

)

$IGNORE(
vim: textwidth=80
)
