#include <DOC.H>

$DOC_INTERFACE(__PrefixOpSuffix,

$TYPE_INLINE_FUNCTION

$ENVIRONMENT(User/kernel, Sync/async/rt-irq, No, Any, No)

$INCLUDES(
$INCLUDE(ARCH/BITOPS.H)
)

$FORMAT(static $LINK(__FINLINE__,__finline__) void
$NOP(__)$ARG(Prefix)$ARG(Op)$ARG(Suffix)(type *$ARG(ptr), type $ARG(val));)

$DESCRIPTION(
This family of inline functions perform an atomic logical operation on
memory. The operation will be performed between $ARG(val) and $ARG(ptr) location
and the result will be stored at $ARG(ptr) location.
$NP
Parts of function name $MDASH $ARG(Op), $ARG(Suffix) and $ARG(Prefix) determine
logical operation, data type and atomicity requirements.
)

$ARGUMENTS(
$ARGUMENT(Prefix, This is the part of function name. It specifies atomicity of
the operation.
$CONSTANTS(
$CONSTANT(empty, Perform an operation that is atomic with respect to events on
the CPU itself (ASTs or real time interrupts) but it is not atomic with respect
to other CPUs or busmasters.)
$CONSTANT(LOCK_, The operation will contain lock prefix, making it atomic with
respect to other CPUs and bus mastering devices.)
)
)
$ARGUMENT(Op, Determine the operation itself. Possibilities:
$CONSTANTS(
$CONSTANT(OR, Bitwise OR.)
$CONSTANT(XOR, Bitwise XOR.)
$CONSTANT(AND, Bitwise AND.)
$CONSTANT(ADD, Adding two values.)
$CONSTANT(SUB, Subtract $ARG(val) from memory location.)
)
)
$ARGUMENT(Suffix, This is the part of function name. It determines argument
types:
$CONSTANTS(
$CONSTANT(C, argument has the type signed or unsigned char or $LINK(__S8, __s8)
or $LINK(__U8, __u8).)
$CONSTANT(I, argument has the type signed or unsigned int.)
$CONSTANT(L, argument has the type signed or unsigned long.)
$CONSTANT(32, argument has the type $LINK(__U32, __u32) or $LINK(__S32, __s32).)
)
)
$ARGUMENT(ptr, Pointer pointing to a memory location that should be atomically
changed.)
$ARGUMENT(val, A value that will be bitwise-ORed at location $ARG(ptr).)
)

$SEE_ALSO(
$LINK(__BITOPS_COND,__PrefixOpSuffixCondition)
$LINK(__CMPXCHG,__PrefixCMPXCHGSuffix)
)

)

$IGNORE(
vim: textwidth=80
)
