#include <DOC.H>

$DOC_INTERFACE(__BSF,

$TYPE_INLINE_FUNCTION

$ENVIRONMENT(User/kernel, Sync/async/rt-irq, No, Any, No)

$INCLUDES(
$INCLUDE(ARCH/BSF.H)
)

$FORMAT(static $LINK(__FINLINE__,__finline__) int
__BSF(unsigned long $ARG(val));)

$DESCRIPTION(
This function returns the index of the least significant non-zero bit in
$ARG(val).  Bits are indexed from 0, the least significant bit has index 0.
)

$ARGUMENTS(
$ARGUMENT(val, A number in which the bit is searched. It must not be zero.)
)

$RETURNS(
An index of the least significant bit that is set.
)

$SEE_ALSO(
$LINK(__BSR,__BSR),
$LINK(__BSF_CONST,__BSF_CONST)
)

)

$IGNORE(
vim: textwidth=80
)
