#include <DOC.H>

$DOC_INTERFACE(__BSR,

$TYPE_INLINE_FUNCTION

$ENVIRONMENT(User/kernel, Sync/async/rt-irq, No, Any, No)

$INCLUDES(
$INCLUDE(ARCH/BSF.H)
)

$FORMAT(static $LINK(__FINLINE__,__finline__) int
__BSR(unsigned long $ARG(val));)

$DESCRIPTION(
This function returns the index of the most significant non-zero bit in
$ARG(val).  Bits are indexed from 0, the least significant bit has index 0.
)

$ARGUMENTS(
$ARGUMENT(val, A number in which the bit is searched. It must not be zero.)
)

$RETURNS(
An index of the most significant bit that is set.
)

$SEE_ALSO(
$LINK(__BSF,__BSF),
$LINK(__BSR_CONST,__BSR_CONST)
)

)

$IGNORE(
vim: textwidth=80
)
