#include <DOC.H>

$DOC_INTERFACE(__BT,

$TYPE_INLINE_FUNCTION

$ENVIRONMENT(User/kernel, Sync/async/rt-irq, No, Any, No)

$INCLUDES(
$INCLUDE(ARCH/BT.H)
)

$FORMAT(static $LINK(__FINLINE__,__finline__) int
__BT(const void *$ARG(ptr), int $ARG(bit));)

$DESCRIPTION(
Test a bit in a memory bitmap.
$NP
The exact layout of the bits in the bitmap is architecture-specific.
The only specified fact is that bits with numbers up to number of bits in long
int type ($CODE(8 * sizeof(long))) map into one long int value in memory. Bits
with numbers up to $CODE(2 * 8 * sizeof(long)) map to the next long int and so
on. Whether the mapping is big-endian or little-endian or from the most
significant bit or from the least significant bit, depends on the architecture.
)

$ARGUMENTS(
$ARGUMENT(ptr, Pointer to a memory bitmap. It must have size at least
$CODE(sizeof(long) * (($ARG(bit) + (sizeof(long) * 8 - 1)) / sizeof(long) / 8))
bytes.
)
$ARGUMENT(bit, A bit in the bitmap. This must be positive number.)
)

$RETURNS(
0 if the bit is clear, 1 if the bit is set.
)

$SEE_ALSO(
$LINK(__BTS,__BTS),
$LINK(__BTR,__BTR),
$LINK(__BTC,__BTC),
$LINK(__BS,__BS),
$LINK(__BR,__BR),
$LINK(__BC,__BC)
)

)

$IGNORE(
vim: textwidth=80
)
