#include <DOC.H>

$DOC_INTERFACE(__BTC,

$TYPE_INLINE_FUNCTION

$ENVIRONMENT(User/kernel, Sync/async/rt-irq, No, Any, No)

$INCLUDES(
$INCLUDE(ARCH/BT.H)
)

$FORMAT(static $LINK(__FINLINE__,__finline__) int
__BTC(void *$ARG(ptr), int $ARG(bit));)

$DESCRIPTION(
Test a bit in a memory bitmap and then negates it. Atomicity of this operation
is not specified $MDASH it should not be performed simultaneously by more
threads or simultaneously by a code and an AST that interrupts it.
$NP
See the definition of $LINK(__BT,__BT) for description of the bitmap format in
memory.
)

$ARGUMENTS(
$ARGUMENT(ptr, Pointer to a memory bitmap. It must have size at least
$CODE(sizeof(long) * (($ARG(bit) + (sizeof(long) * 8 - 1)) / sizeof(long) / 8))
bytes.
)
$ARGUMENT(bit, A bit in the bitmap. This must be positive number.)
)

$RETURNS(
0 if the bit was clear, 1 if the bit was set.
)

$SEE_ALSO(
$LINK(__BT,__BT),
$LINK(__BTS,__BTS),
$LINK(__BTR,__BTR),
$LINK(__BS,__BS),
$LINK(__BR,__BR),
$LINK(__BC,__BC)
)

)

$IGNORE(
vim: textwidth=80
)
