#include <DOC.H>

$DOC_INTERFACE(__BVR,

$TYPE_INLINE_FUNCTION

$ENVIRONMENT(User/kernel, Sync/async/rt-irq, No, Any, No)

$INCLUDES(
$INCLUDE(ARCH/BT.H)
)

$FORMAT(static $LINK(__FINLINE__,__finline__) unsigned long
__BVR(unsigned long $ARG(val), int $ARG(bit));)

$DESCRIPTION(
This function uses the same bitmap format as $LINK(__BT,__BT) and similar
$CODE(__B*) functions, but it operates only on one long int. It doesn't operate
in memory, but it returns a modified version of the word.
$NP
This function clears a bit in an unsigned long int and returns the new value.
)

$ARGUMENTS(
$ARGUMENT(val, A value in which the bit will be cleared.)
$ARGUMENT(bit, A bit index. The mapping of bits in the unsigned long int is
architecture-specific. The $ARG(bit) argument must be in the range $CODE(0)
$NDASH $CODE(sizeof(long) * 8 - 1).)
)

$RETURNS(
A value $ARG(val) with the bit cleared.
)

$SEE_ALSO(
$LINK(__BVS,__BVS),
$LINK(__BVC,__BVC),
$LINK(__BSCAN,__BSCAN),
$LINK(__BT,__BT),
$LINK(__BTS,__BTS),
$LINK(__BTR,__BTR),
$LINK(__BTC,__BTC),
$LINK(__BS,__BS),
$LINK(__BR,__BR),
$LINK(__BC,__BC)
)

)

$IGNORE(
vim: textwidth=80
)
