#include <DOC.H>

$DOC_INTERFACE(__PrefixCMPXCHGSuffix,

$TYPE_INLINE_FUNCTION

$ENVIRONMENT(User/kernel, Sync/async/rt-irq, No, Any, No)

$INCLUDES(
$INCLUDE(ARCH/BITOPS.H)
)

$FORMAT(static $LINK(__FINLINE__,__finline__) long
$NOP(__)$ARG(Prefix)$NOP(CMPXCHG)$ARG(Suffix)(type *$ARG(ptr), type $ARG(old),
type $ARG(new));)

$DESCRIPTION(
This family of inline functions compare a memory location with $ARG(old)
argument and if they are equal, they write $ARG(new) argument to the memory
location. This operation is performed atomically.
$NP
Parts of function name $MDASH $ARG(Prefix) and $ARG(Suffix) determine atomicity
requirements and data type.
)

$ARGUMENTS(
$ARGUMENT(Prefix, This is the part of function name. It specifies atomicity of
the operation.
$CONSTANTS(
$CONSTANT(empty, Perform an operation that is atomic with respect to events on
the CPU itself (ASTs or real time interrupts) but it is not atomic with respect
to other CPUs or busmasters.)
$CONSTANT(LOCK_, The operation will contain lock prefix, making it atomic with
respect to other CPUs and bus mastering devices.)
)
)
$ARGUMENT(Suffix, This is the part of function name. It determines argument
types:
$CONSTANTS(
$CONSTANT(C, argument has the type signed or unsigned char or $LINK(__S8, __s8)
or $LINK(__U8, __u8).)
$CONSTANT(I, argument has the type signed or unsigned int.)
$CONSTANT(L, argument has the type signed or unsigned long.)
$CONSTANT(32, argument has the type $LINK(__U32, __u32) or $LINK(__S32, __s32).)
$CONSTANT(64, argument has the type $LINK(__U64, __u64) or $LINK(__S64, __s64).
This variant is available only if macro
$LINK(__CMPXCHG64_AVAILABLE,__CMPXCHG64_AVAILABLE) returns non-zero. If this
macro returns zero, 64-bit CMPXCHG must not be performed, because it would cause
a crash.)
)
)
$ARGUMENT(ptr, Pointer pointing to a memory location that should be atomically
changed.)
$ARGUMENT(old, Compare memory location with this value.)
$ARGUMENT(new, Write this value to the memory location, if it was equal to
$ARG(old).)
)

$RETURNS(
This function returns non-zero if the compare didn't match (in that case the
memory location is unchanged) and zero if it matched (in that case, $ARG(new)
was written to the memory location). It may return any non-zero value in the
case of mismatch, do not pass the value directly to $LINK(__LIKELY,__likely) or
$LINK(__UNLIKELY,__unlikely) because they expect $CODE(int) argument $MDASH use
$CODE(if (__likely(__CMPXCHG...(...) != 0))).
)

$SEE_ALSO(
$LINK(__BITOPS,__PrefixOpSuffix),
$LINK(__BITOPS_COND,__PrefixOpSuffixCondition),
$LINK(__CMPXCHG64_AVAILABLE,__CMPXCHG64_AVAILABLE)
)

)

$IGNORE(
vim: textwidth=80
)
