#include <DOC.H>

$DOC_INTERFACE(__ERR_PTR,

$ENVIRONMENT(User/kernel, Sync/async/rt-irq, No, Any, No)

$TYPE_MACRO_EXPRESSION

$INCLUDES(
$INCLUDE(SYS/TYPES.H)
)

$FORMAT(void *p = __ERR_PTR($ARG(err)))

$DESCRIPTION(
This macro converts a negative error code to a pointer. The conversion method is
architecture-specific. The returned pointer won't collide with any other pointer
to aby object.
$NP
The macro is used in functions that return pointer, but also need to return an
error code.
)

$ARGUMENTS(
$ARGUMENT(err, A negative integer representing an error code.)
)

$RETURNS(
This macro returns a void pointer with encoded error code.
)

$SEE_ALSO($LINK(__PTR_ERR,__PTR_ERR), $LINK(__IS_ERR,__IS_ERR))
)

$IGNORE(
vim: textwidth=80
)
