#include <DOC.H>

$DOC_INTERFACE(__is_constant,

$TYPE_MACRO_EXPRESSION

$INCLUDES(
$INCLUDE(SYS/TYPES.H)
)

$FORMAT(if (__is_constant($ARG(expression))) ...)

$DESCRIPTION(
This macro expands to a compiler-specific function that is evaluated at
compile-time and that tells if the expression is constant.
$NP
It may be used for alternate code paths in inline functions, that will be
generated for constant or non-constant arguments. Because $CODE(__is_constant)
is always evaluated at compile-time, one of the branches of the $CODE(if)
statement will always be removed by the optimizer.
$NP
The caller should not depend on the ability of a compiler to return this
information. This macro should be used only for optimization purposes.
)

$ARGUMENTS(
$ARGUMENT(expression, An integer type expression. The expression is not
evaluated at run-time. Compiler checks if the expression is constant at
compile-time.)
)

$RETURNS(This macro returns non-zero if the compiler can prove that the
expression is constant. If it can't prove it (either because the expression is
too complex or if optimizations are turned off), it returns 0. It also returns 0
if the compiler doesn't support this functionality.
)

$IMPLEMENTATION(On gcc compiler, this macro expands to
$CODE(__builtin_constant_p($ARG(expression) + $ARG(expression))) function.
Summing two expressions is required as a workaround against a bug.
)

$SEE_ALSO($LINK(__LIKELY,__likely), $LINK(__UNLIKELY,__unlikely))

)

$IGNORE(
vim: textwidth=80
)
