#include <DOC.H>

$DOC_INTERFACE(__PTR_ERR,

$TYPE_MACRO_EXPRESSION

$ENVIRONMENT(User/kernel, Sync/async/rt-irq, No, Any, No)

$INCLUDES(
$INCLUDE(SYS/TYPES.H)
)

$FORMAT(int e = __PTR_ERR($ARG(ptr)))

$DESCRIPTION(
This macro converts an error code encoded in pointer with
$LINK(__ERR_PTR,__ERR_PTR) back to negative error code.
)

$ARGUMENTS(
$ARGUMENT(ptr, A pointer that was returned with $LINK(__ERR_PTR,__ERR_PTR))
)

$RETURNS(
This macro returns a negative error code.
)

$SEE_ALSO($LINK(__ERR_PTR,__ERR_PTR), $LINK(__IS_ERR,__IS_ERR))
)

$IGNORE(
vim: textwidth=80
)
