#include <DOC.H>

$DOC_INTERFACE(__PURE_ATTR__,

$TYPE_MACRO_TYPE_ATTRIBUTE

$INCLUDES(
$INCLUDE(SYS/TYPES.H)
)

$FORMAT(int __PURE_ATTR__ function(args...);)

$DESCRIPTION(
This macro expands to a compiler-specific attribute telling that the function
doesn't have side effects. Its return value may depend on its arguments or on
content of program's memory, but it may not change content of program's memory.
$NP
$CODE(__PURE_ATTR__) has weaker requirements than
$LINK(__CONST_ATTR__,__CONST_ATTR__). Any function that is const, is pure, but
some functions may be pure and not const.
$NP
It enables the compiler to do better optimizations.
)

$IMPLEMENTATION(When using the gcc compiler, this macro expands to
$CODE(__attribute__((__pure__))).

$SEE_ALSO(
$LINK(__CONST_ATTR__,__CONST_ATTR__))
)

)

$IGNORE(
vim: textwidth=80
)
