#include <DOC.H>

$DOC_INTERFACE(__unlikely,

$TYPE_MACRO_EXPRESSION

$INCLUDES(
$INCLUDE(SYS/TYPES.H)
)

$FORMAT(if (__unlikely($ARG(condition))) ...)

$DESCRIPTION(
This macro returns its argument and informs the compiler that the argument is
likely zero. The compiler uses this information to optimize placement of
code branches following an $CODE(if) or $CODE(while) statement.
)

$ARGUMENTS(
$ARGUMENT(condition, This is an expression having type $CODE(int). Be especially
careful to not pass long or pointer values to this function.)
)

$RETURNS(This macro returns its argument unchanged.)

$IMPLEMENTATION(On gcc compiler, this macro expands to
$CODE(__builtin_expect(($ARG(condition)), 0)) function.
)

$SEE_ALSO($LINK(__LIKELY,__likely))

)

$IGNORE(
vim: textwidth=80
)
