#ifndef __ATA_ACTRL_H
#define __ATA_ACTRL_H

#include <SYS/TYPES.H>
#include <SPAD/LIBC.H>
#include <SPAD/TIMER.H>
#include <SPAD/AC.H>
#include <SPAD/IRQ.H>
#include <SPAD/PCI.H>
#include <SPAD/RANDOM.H>
#include <ARCH/IO.H>

#include <SPAD/ATA.H>
#include <SPAD/SCSI.H>

#include "ACTRLREG.H"

#define PROBE_LIMIT_JIFFIES	(JIFFIES_PER_SECOND * 3)

typedef struct __actrl ACTRL;
/*typedef struct __aport APORT;*/
typedef struct __adevice ADEVICE;

struct __adevice {
	ATA_ATTACH_PARAM *attached;
	unsigned dev_flags;
};

/* 0x1 - 0x00020000  --- IDE_XFER_* */
#define DEV_F_MASKIRQ		0x01000000U
#define DEV_F_IO32		0x02000000U
#define DEV_F_ATAPI		0x04000000U
#define DEV_F_ATAPI_DMADIR	0x08000000U
#define DEV_F_ATAPI_DRQ_INT	0x10000000U
#define DEV_F_ATAPI_LONG_DRQ	0x20000000U
#define DEV_F_ATAPI_CMD_16	0x40000000U
#define DEV_F_ATAPI_DMA		0x80000000U

struct __aport {
	ACTRL *ctrl;
	io_t io;
	io_t alt_io;
	io_t dma_io;
	unsigned char aport_flags;
	ATARQ *current_rq;
	ASGLIST *sglist;
	__u32 sglist_dev;
	ADEVICE device[2];
	AST irq_ast;
	IRQ_HANDLE *irq_ctrl;
	TIMER timeout;
	RANDOM_CTX random_ctx;

	void (*setup_xfer)(APORT *p, ATARQ *rq);/* if APORT_SETUP_XFER */
	void (*mangle)(APORT *p, ATARQ *rq);	/* if APORT_MANGLE_REQUEST */
	void (*start_dma)(APORT *p, ATARQ *rq);	/* if APORT_EXTRA_DMA */
	__u8 (*stop_dma)(APORT *p, __u8 mask);	/* if APORT_EXTRA_DMA */

	unsigned long port_chipset_flags;	/* usable for chipset */

	unsigned char xfer_mode[2][2];		/* usable for chipset */

	u_jiffies_lo_t probe_limit;

	unsigned recommended_length;

	int (*check_atapi_dma)(APORT *p, SCSIRQ *rq);
	void (*get_avail_xfer)(APORT *p, int drive, const __u16 ident[256], unsigned *avail, unsigned *avail_unsupported);
	int (*set_xfer)(APORT *p, int drive, unsigned xfer, const __u16 ident[256]);
	int (*fixup_ident)(APORT *p, int drive, __u16 ident[256]);

	/* ATAPI */
	unsigned atapi_length;
	SCSIRQ *scsirq;
	ATARQ atapi_placeholder;
	__u8 error_register;
	SCSIRQ *orig_scsirq;
	DECL_SCSIRQ(6) sense_rq;
	BIODESC sense_desc;

	unsigned n;

	int irq;

	unsigned pio_n_sect;
	unsigned pio_sg_pos;
	u_jiffies_lo_t pio_timeout;

	IO_RANGE io_range;
	IO_RANGE alt_io_range;
	IO_RANGE dma_io_range;
};

/* APORT->aport_flags */
#define APORT_DISABLED			0x01
#define APORT_SATA			0x02
#define APORT_IMPLICIT_DMA		0x04
#define APORT_SETUP_XFER		0x08
#define APORT_MANGLE_REQUEST		0x10
#define APORT_EXTRA_DMA			0x20
#define APORT_LOCK			0x80


struct __actrl {
	__u8 n_ports;

	char pci_dll;
	char on_pci;
	__u8 dev_rev;
	__u32 dev_id;
	pci_id_t pci_id;
	unsigned actrl_flags;
	unsigned bus_clock;

	int dcall_users;

	void *lnte, *dlrq;
	char dev_name[__MAX_STR_LEN];

	char *chipset_name;
	void (*chipset_dtor)(ACTRL *);

	unsigned long chipset_flags;
	unsigned long chipset_flags_2;

	IO_RANGE chipset_range;

	APORT port[1];
};

/* ACTRL->actrl_flags */
#define ACTRL_ALWAYS_NATIVE	0x01
#define ACTRL_SPECIAL_PORTS	0x02
#define ACTRL_SATA		0x04
#define ACTRL_FORCE_MASKIRQ	0x08
#define ACTRL_LIMIT_PROBE	0x10
#define ACTRL_BOTCHED_IDENTIFY	0x20
#define ACTRL_TRY_NONSIMPLEX	0x40
#define ACTRL_IGNORE_SIMPLEX	0x80

#define ATA_OUT_DATA16(p, v)		io_outw((p)->io + PORT_DATA, v)
#define ATA_OUT_FEATURES(p, v)		io_outb((p)->io + PORT_FEATURES, v)
#define ATA_OUT_COUNT(p, v)		io_outb((p)->io + PORT_COUNT, v)
#define ATA_OUT_LBA_L(p, v)		io_outb((p)->io + PORT_LBA_L, v)
#define ATA_OUT_LBA_M(p, v)		io_outb((p)->io + PORT_LBA_M, v)
#define ATA_OUT_LBA_H(p, v)		io_outb((p)->io + PORT_LBA_H, v)
#define ATA_OUT_DRIVE(p, v)		io_outb((p)->io + PORT_DRIVE, v)
#define ATA_OUT_CMD(p, v)		io_outb((p)->io + PORT_CMD, v)
#define ATA_IN_DATA16(p)		io_inw((p)->io + PORT_DATA)
#define ATA_IN_ERROR(p)			io_inb((p)->io + PORT_ERROR)
#define ATA_IN_FEATURES(p)		io_inb((p)->io + PORT_FEATURES)
#define ATA_IN_COUNT(p)			io_inb((p)->io + PORT_COUNT)
#define ATA_IN_LBA_L(p)			io_inb((p)->io + PORT_LBA_L)
#define ATA_IN_LBA_M(p)			io_inb((p)->io + PORT_LBA_M)
#define ATA_IN_LBA_H(p)			io_inb((p)->io + PORT_LBA_H)
#define ATA_IN_DRIVE(p)			io_inb((p)->io + PORT_DRIVE)
#define ATA_IN_STATUS(p)		io_inb((p)->io + PORT_STATUS)

#define ATA_OUT_CTRL(p, v)		io_outb((p)->alt_io + ALTPORT_CTRL, v)
#define ATA_IN_ALTSTATUS(p)		io_inb((p)->alt_io + ALTPORT_STATUS)

int ATA_FIND_DEV(ACTRL *a, __u32 dev_id, __u8 rev_min, __u8 rev_max);

static __finline__ void setup_dma_generic(APORT *p, ATARQ *rq)
{
	io_outl(p->dma_io + DMAPORT_DTP, p->sglist_dev);
	io_outb(p->dma_io + DMAPORT_CMD, ~rq->atarq_flags & DMACMD_READ);
}

static __finline__ void start_dma_generic(APORT *p, ATARQ *rq)
{
	io_outb(p->dma_io + DMAPORT_CMD, (~rq->atarq_flags & DMACMD_READ) | DMACMD_BMEN);
}

static __finline__ void stop_dma_generic(APORT *p, __u8 dmastatus)
{
	io_outb(p->dma_io + DMAPORT_CMD, 0);
	io_outb(p->dma_io + DMAPORT_STATUS, dmastatus | DMASTATUS_IRQ | DMASTATUS_ERROR);
}

#define IS_ATAPI(p, rq)		((rq) == &(p)->atapi_placeholder)

void SATA_GET_AVAIL_XFER(APORT *p, int drive, const __u16 ident[256], unsigned *avail, unsigned  *avail_unsupported);

/* Controller drivers */

int DETECT_RZ1000(ACTRL *a);
int DETECT_VIA(ACTRL *a);
int DETECT_INTEL(ACTRL *a);
int DETECT_SVW(ACTRL *a);
int DETECT_ALI(ACTRL *a);
int DETECT_IT821(ACTRL *a);
int DETECT_TRIFLEX(ACTRL *a);
int DETECT_CMD(ACTRL *a);
int DETECT_SII(ACTRL *a);
int DETECT_PDC(ACTRL *a);
int DETECT_PDC2(ACTRL *a);
int DETECT_HPT(ACTRL *a);
int DETECT_JMB(ACTRL *a);

int DETECT_VT6421(pci_id_t pci_id, int (**special_init)(ACTRL *a));
int DETECT_ULI_4PORT(pci_id_t pci_id, int (**special_init)(ACTRL *a));

#endif
