#include <ARCH/IO.H>
#include <STRING.H>

#include "ACTRL.H"

#define CMD_CFR			0x50
#define  CMD_CFR_DEVREV			0x03
#define  CMD_CFR_PRI_IRQ		0x04
#define  CMD_CFR_DEVID			0x18
#define  CMD_CFR_AT_VESA_78		0x20
#define  CMD_CFR_JP1			0x40
#define CMD_CNTRL		0x51
#define  CMD_CNTRL_PRIMARY_EN		0x04
#define  CMD_CNTRL_SECONDARY_EN		0x08
#define  CMD_CNTRL_PRI_MASTER_RDA	0x40
#define  CMD_CNTRL_PRI_SLAVE_RDA	0x80
#define CMD_CMDTIM		0x52
#define  CMD_CMDTIM_RECOVERY		0x0f
#define  CMD_CMDTIM_ACTIVE		0xf0
#define CMD_ARTTIM0		0x53
#define  CMD_ARTTIM0_PRI_MASTER		0xc0
#define CMD_DRWTIM0		0x54
#define  CMD_DRWTIM0_RECOVERY		0x0f
#define  CMD_DRWTIM0_ACTIVE		0xf0
#define CMD_ARTTIM1		0x55
#define  CMD_ARTTIM1_PRI_SLAVE		0xc0
#define CMD_DRWTIM1		0x56
#define  CMD_DRWTIM1_RECOVERY		0x0f
#define  CMD_DRWTIM1_ACTIVE		0xf0
#define CMD_ARTTIM23		0x57
#define  CMD_ARTTIM23_SEC_MASTER_RDA	0x04
#define  CMD_ARTTIM23_SEC_SLAVE_RDA	0x08
#define  CMD_ARTTIM23_SEC_IRQ		0x10
#define  CMD_ARTTIM23_SEC		0xc0
#define CMD_DRWTIM2		0x58
#define  CMD_DRWTIM2_RECOVERY		0x0f
#define  CMD_DRWTIM2_ACTIVE		0xf0
#define CMD_BRST		0x59
#define CMD_DRWTIM3		0x5b
#define  CMD_DRWTIM3_RECOVERY		0x0f
#define  CMD_DRWTIM3_ACTIVE		0xf0
#define CMD_BMIDECR0		0x70
#define  CMD_BMIDECR0_GO		0x01
#define  CMD_BMIDECR0_READ		0x08
#define CMD_MRDMODE		0x71
#define  CMD_MRDMODE_MEM_MODE		0x03
#define   CMD_MRDMODE_MEM_MODE_READ		0x00
#define   CMD_MRDMODE_MEM_MODE_READ_MULTIPLE	0x01
#define   CMD_MRDMODE_MEM_MODE_READ_LINE	0x02
#define  CMD_MRDMODE_PRI_IRQ		0x04
#define  CMD_MRDMODE_SEC_IRQ		0x08
#define  CMD_MRDMODE_PRI_IRQ_MASK	0x10
#define  CMD_MRDMODE_SEC_IRQ_MASK	0x20
#define  CMD_MRDMODE_PRI_RESET		0x40
#define  CMD_MRDMODE_SEC_RESET		0x80
#define CMD_BMIDESR0		0x72
#define  CMD_BMIDESR0_ACTIVE		0x01
#define  CMD_BMIDESR0_ERROR		0x02
#define  CMD_BMIDESR0_IRQ		0x04
#define  CMD_BMIDESR0_MASTER_DMA_CAP	0x20
#define  CMD_BMIDESR0_SLAVE_DMA_CAP	0x40
#define  CMD_BMIDESR0_SIMPLEX		0x80
#define CMD_UIDETCR0		0x73
#define  CMD_UIDETCR0_PRI_MASTER_UDMA	0x01
#define  CMD_UIDETCR0_PRI_SLAVE_UDMA	0x02
#define  CMD_UIDETCR0_PRI_MASTER_CLKRES	0x04
#define  CMD_UIDETCR0_PRI_SLAVE_CLKRES	0x08
#define  CMD_UIDETCR0_PRI_MASTER_CLK	0x30
#define  CMD_UIDETCR0_PRI_SLAVE_CLK	0xc0
#define CMD_DTPR0		0x74
#define CMD_BMIDECR1		0x78
#define  CMD_BMIDECR1_GO		0x01
#define  CMD_BMIDECR1_READ		0x08
#define CMD_BMIDESCR		0x79
#define  CMD_BMIDESCR_PRI_WIRE80	0x01
#define  CMD_BMIDESCR_SEC_WIRE80	0x02
#define  CMD_BMIDESCR_FIFO_READ		0x30
#define  CMD_BMIDESCR_FIFO_WRITE	0xc0
#define CMD_BMIDESR1		0x7a
#define  CMD_BMIDESR1_ACTIVE		0x01
#define  CMD_BMIDESR1_ERROR		0x02
#define  CMD_BMIDESR1_IRQ		0x04
#define  CMD_BMIDESR1_MASTER_DMA_CAP	0x20
#define  CMD_BMIDESR1_SLAVE_DMA_CAP	0x40
#define  CMD_BMIDESR1_SIMPLEX		0x80
#define CMD_UIDETCR1		0x7b
#define  CMD_UIDETCR1_SEC_MASTER_UDMA	0x01
#define  CMD_UIDETCR1_SEC_SLAVE_UDMA	0x02
#define  CMD_UIDETCR1_SEC_MASTER_CLKRES	0x04
#define  CMD_UIDETCR1_SEC_SLAVE_CLKRES	0x08
#define  CMD_UIDETCR1_SEC_MASTER_CLK	0x30
#define  CMD_UIDETCR1_SEC_SLAVE_CLK	0xc0
#define CMD_DTPR1		0x7c
#define CMD_SHADOW		0x8c

#define FLAGS_CMD_640_NO_DMA		0
#define FLAGS_CMD_643_NO_UDMA		1
#define FLAGS_CMD_646_NO_UDMA_REV1	2
#define FLAGS_CMD_646_NO_UDMA		3
#define FLAGS_CMD_646_UDMA		4
#define FLAGS_CMD_648_UDMA		5
#define FLAGS_CMD_649_UDMA		6
#define FLAGS_REVISION			7

#define FLAGS_VLB_KEY_178		8
#define FLAGS_VLB_KEY_78		16

#define CMD_REVISION(a)			((a)->chipset_flags & FLAGS_REVISION)

#ifdef __i386__
#define CMD_SUPPORT_VLB
#endif

static void CMD_GET_AVAIL_XFER(APORT *p, int drive, const __u16 ident[256], unsigned *avail, unsigned *avail_unsupported);
static int CMD_SET_XFER(APORT *p, int drive, unsigned mode, const __u16 id[256]);
static __u8 CMD_STOP_DMA(APORT *p, __u8 mask);
#ifdef CMD_SUPPORT_VLB
static void CMD_VLBUS_DTOR(ACTRL *a);
#endif

__COLD_ATTR__ static __u8 CMD_READ_CONFIG_BYTE(ACTRL *a, __u8 reg)
{
#ifdef CMD_SUPPORT_VLB
	if (a->chipset_flags & FLAGS_VLB_KEY_178) {
		io_outb_p(0x178, reg);
		return io_inb_p(0x179);
	}
	if (a->chipset_flags & FLAGS_VLB_KEY_78) {
		io_outb_p(0x78, reg);
		return io_inb_p(0x79);
	}
#endif
	return PCI$READ_CONFIG_BYTE(a->pci_id, reg);
}

__COLD_ATTR__ static void CMD_WRITE_CONFIG_BYTE(ACTRL *a, __u8 reg, __u8 val)
{
#ifdef CMD_SUPPORT_VLB
	if (a->chipset_flags & FLAGS_VLB_KEY_178) {
		io_outb_p(0x178, reg);
		io_outb_p(0x179, val);
		return;
	}
	if (a->chipset_flags & FLAGS_VLB_KEY_78) {
		io_outb_p(0x78, reg);
		io_outb_p(0x79, val);
		return;
	}
#endif
	PCI$WRITE_CONFIG_BYTE(a->pci_id, reg, val);
}

#ifdef CMD_SUPPORT_VLB
__COLD_ATTR__ static int TEST_VLB_CMD(ACTRL *a)
{
	__u8 val = CMD_READ_CONFIG_BYTE(a, CMD_CFR);
	if (!val || val == 0xff)
		return -1;
	if (!(val & CMD_CFR_DEVREV))
		return -1;
	if (!!(a->chipset_flags & FLAGS_VLB_KEY_78) != !!(val & CMD_CFR_AT_VESA_78))
		return -1;
	CMD_WRITE_CONFIG_BYTE(a, 0x5b, 0xbd);
	if (CMD_READ_CONFIG_BYTE(a, 0x5b) != 0xbd)
		return -1;
	CMD_WRITE_CONFIG_BYTE(a, 0x5b, 0x00);
	return 0;
}
#endif

__COLD_ATTR__ int DETECT_CMD(ACTRL *a)
{
	int i;

	if (a->dev_id == 0x06401095) a->chipset_flags = FLAGS_CMD_640_NO_DMA;
	else if (a->dev_id == 0x06431095) a->chipset_flags = FLAGS_CMD_643_NO_UDMA;
	else if (a->dev_id == 0x06461095) {
		__u8 rv = PCI$READ_CONFIG_BYTE(a->pci_id, PCI_REVISION_ID);
		if (rv > 4) a->chipset_flags = FLAGS_CMD_646_UDMA;
		else if (rv == 1) a->chipset_flags = FLAGS_CMD_646_NO_UDMA_REV1;
		else a->chipset_flags = FLAGS_CMD_646_NO_UDMA;
	} else if (a->dev_id == 0x06481095) a->chipset_flags = FLAGS_CMD_648_UDMA;
	else if (a->dev_id == 0x06491095) a->chipset_flags = FLAGS_CMD_649_UDMA;
	else {
		if (a->on_pci)
			return 0;
#ifdef CMD_SUPPORT_VLB
		a->chipset_flags = FLAGS_CMD_640_NO_DMA | FLAGS_VLB_KEY_178;
		a->chipset_range.start = 0x178;
		a->chipset_range.len = 2;
		a->chipset_range.name = "ATA$ACTRL";
		if (KERNEL$REGISTER_IO_RANGE(&a->chipset_range))
			goto skip_178;
		if (!TEST_VLB_CMD(a))
			goto have_vlb;
		KERNEL$UNREGISTER_IO_RANGE(&a->chipset_range);
		skip_178:
		a->chipset_flags = FLAGS_CMD_640_NO_DMA | FLAGS_VLB_KEY_78;
		a->chipset_range.start = 0x78;
		a->chipset_range.len = 2;
		a->chipset_range.name = "ATA$ACTRL";
		if (KERNEL$REGISTER_IO_RANGE(&a->chipset_range))
			goto skip_78;
		if (!TEST_VLB_CMD(a))
			goto have_vlb;
		KERNEL$UNREGISTER_IO_RANGE(&a->chipset_range);
		skip_78:
		a->chipset_flags = 0;
		return 0;
		have_vlb:
		a->chipset_name = "CMD 640 (VL-BUS)";
		a->chipset_dtor = CMD_VLBUS_DTOR;
#else
		return 0;
#endif
	}

	if (CMD_REVISION(a) <= FLAGS_CMD_640_NO_DMA) {
		/* That famous data corruption bug ... */
		a->actrl_flags |= ACTRL_FORCE_MASKIRQ;
	} else {
		__u8 mrdmode;
		PCI$WRITE_CONFIG_BYTE(a->pci_id, PCI_LATENCY_TIMER, 64);

		mrdmode = PCI$READ_CONFIG_BYTE(a->pci_id, CMD_MRDMODE);	/* nemrdam, protoze mam poruchu osobnosti */
		mrdmode &= ~0xf3;
		mrdmode |= 0x02;
		PCI$WRITE_CONFIG_BYTE(a->pci_id, CMD_MRDMODE, mrdmode);
	}

	CMD_WRITE_CONFIG_BYTE(a, CMD_BRST, 0x40);

	for (i = 0; i < a->n_ports; i++) {
		a->port[i].get_avail_xfer = CMD_GET_AVAIL_XFER;
		a->port[i].set_xfer = CMD_SET_XFER;
		a->port[i].xfer_mode[0][0] = 0xff;
		a->port[i].xfer_mode[0][1] = 0xff;
		a->port[i].xfer_mode[1][0] = 0xff;
		a->port[i].xfer_mode[1][1] = 0xff;
		if (CMD_REVISION(a) >= FLAGS_CMD_648_UDMA) {
			a->port[i].aport_flags |= APORT_EXTRA_DMA;
			a->port[i].start_dma = start_dma_generic;
			a->port[i].stop_dma = CMD_STOP_DMA;
		}
	}

	return 1;
}

#ifdef CMD_SUPPORT_VLB
__COLD_ATTR__ static void CMD_VLBUS_DTOR(ACTRL *a)
{
	KERNEL$UNREGISTER_IO_RANGE(&a->chipset_range);
}
#endif

__COLD_ATTR__ static void CMD_GET_AVAIL_XFER(APORT *p, int drive, const __u16 ident[256], unsigned *avail, unsigned *avail_unsupported)
{
	ACTRL *a = p->ctrl;
	*avail = IDE_XFER_PIO_0 | IDE_XFER_PIO_1 | IDE_XFER_PIO_2 | IDE_XFER_PIO_3 | IDE_XFER_PIO_4 | IDE_XFER_PIO_5 | IDE_XFER_PIO_6;
	*avail_unsupported = 0;
	if (CMD_REVISION(a) >= FLAGS_CMD_643_NO_UDMA)
		*avail |= IDE_XFER_WDMA_0 | IDE_XFER_WDMA_1 | IDE_XFER_WDMA_2 | IDE_XFER_WDMA_3 | IDE_XFER_WDMA_4;
	if (CMD_REVISION(a) >= FLAGS_CMD_646_UDMA)
		*avail |= IDE_XFER_UDMA_0 | IDE_XFER_UDMA_1 | IDE_XFER_UDMA_2;
	if (CMD_REVISION(a) >= FLAGS_CMD_648_UDMA)
		*avail |= IDE_XFER_UDMA_3 | IDE_XFER_UDMA_4;
	if (CMD_REVISION(a) >= FLAGS_CMD_649_UDMA)
		*avail |= IDE_XFER_UDMA_5;
	
	if (CMD_REVISION(a) >= FLAGS_CMD_648_UDMA) {
		__u8 bmidescr = CMD_READ_CONFIG_BYTE(a, CMD_BMIDESCR);
		if (!(bmidescr & (CMD_BMIDESCR_PRI_WIRE80 << p->n)))
			ATA$CABLE40_RESTRICT(avail, avail_unsupported);
	}
}

static const __u8 SETUP_TABLE[4] = { 0x40, 0x80, 0x00, 0xc0 };
static const __u8 ACTIVE_TABLE[16] = { 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70, 0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0, 0x00 };
static const __u8 RECOVER_640_TABLE[16] = { 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x00 };
static const __u8 RECOVER_TABLE[16] = { 0x0f, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x00 };
static const __u8 PIOREG_TABLE[4] = { CMD_DRWTIM0, CMD_DRWTIM1, CMD_DRWTIM2, CMD_DRWTIM3 };
static const __u8 UDMAREG_TABLE[2] = { CMD_UIDETCR0, CMD_UIDETCR1 };
static const __u8 UDMA_TABLE1[6] = { 0x30, 0x20, 0x10, 0x20, 0x10, 0x00 };
static const __u8 UDMA_TABLE2[6] = { 0x00, 0x00, 0x00, 0x04, 0x04, 0x04 };
static const __u8 DMAREG_TABLE[2] = { CMD_BMIDESR0, CMD_BMIDESR1 };
static const __u8 PREFREG_TABLE[4] = { CMD_CNTRL, CMD_CNTRL, CMD_ARTTIM23, CMD_ARTTIM23 };
static const __u8 PREFBIT_TABLE[4] = { CMD_CNTRL_PRI_MASTER_RDA, CMD_CNTRL_PRI_SLAVE_RDA, CMD_ARTTIM23_SEC_MASTER_RDA, CMD_ARTTIM23_SEC_SLAVE_RDA };

__COLD_ATTR__ static int CMD_SET_XFER(APORT *p, int drive, unsigned mode, const __u16 id[256])
{
	ACTRL *a = p->ctrl;
	APORT *op = &a->port[p->n ^ 1];
	struct ata_timing t;
	__u8 setup, active, recover, act8b, rec8b;
	int atapi = ATA$IS_ATAPI(id);
	if (mode & IDE_XFER_MASK_PIO) {
		p->xfer_mode[0][drive] = ATA$XFER_GET_NUMBER(mode, IDE_XFER_MASK_PIO);
	} else {
		p->xfer_mode[1][drive] = ATA$XFER_GET_NUMBER(mode, IDE_XFER_MASK_DMA);
	}
	ATA$INIT_TIMING(&t);
	ATA$MERGE_PIO_TIMING(&t, p->xfer_mode[0][drive], ATA_MERGE_ALL);
	ATA$MERGE_DMA_TIMING(&t, p->xfer_mode[1][drive], ATA_MERGE_ALL);
	ATA$MERGE_PIO_TIMING(&t, p->xfer_mode[0][drive ^ 1], ATA_MERGE_SETUP | ATA_MERGE_8BIT);
	ATA$MERGE_PIO_TIMING(&t, op->xfer_mode[0][0], ATA_MERGE_8BIT);
	ATA$MERGE_PIO_TIMING(&t, op->xfer_mode[0][1], ATA_MERGE_8BIT);
	ATA$QUANTIZE_TIMING(&t, a->bus_clock, 0);
	if (t.recover > 16) {
		t.active += t.recover - 16;
		t.recover = 16;
	}
	/*__debug_printf("setup (mode %x) %x, active %x, recover %x, act8b %x, rec8b %x\n", mode, t.setup, t.active, t.recover, t.act8b, t.rec8b);*/
	if (t.setup) {
		setup = SETUP_TABLE[ATA$FIT_TIMING(t.setup, 2, 5, 2)];
		if (!p->n) {
			__u8 arttim = CMD_READ_CONFIG_BYTE(a, CMD_ARTTIM0);
			arttim &= ~CMD_ARTTIM0_PRI_MASTER;
			arttim |= setup;
			CMD_WRITE_CONFIG_BYTE(a, CMD_ARTTIM0, arttim);
			arttim = CMD_READ_CONFIG_BYTE(a, CMD_ARTTIM1);
			arttim &= ~CMD_ARTTIM1_PRI_SLAVE;
			arttim |= setup;
			CMD_WRITE_CONFIG_BYTE(a, CMD_ARTTIM1, arttim);
		} else {
			__u8 arttim = CMD_READ_CONFIG_BYTE(a, CMD_ARTTIM23);
			arttim &= ~CMD_ARTTIM23_SEC;
			arttim |= setup;
			CMD_WRITE_CONFIG_BYTE(a, CMD_ARTTIM23, arttim);
		}
	}
	if (t.act8b && t.rec8b) {
		act8b = ACTIVE_TABLE[ATA$FIT_TIMING(t.act8b, 1, 16, 1)];
		if (CMD_REVISION(a) <= FLAGS_CMD_640_NO_DMA) {
			rec8b = RECOVER_640_TABLE[ATA$FIT_TIMING(t.rec8b, 2, 17, 2)];
		} else {
			rec8b = RECOVER_TABLE[ATA$FIT_TIMING(t.rec8b, 1, 16, 1)];
		}
		CMD_WRITE_CONFIG_BYTE(a, CMD_CMDTIM, act8b | rec8b);
	}
	if (t.active && t.recover) {
		active = ACTIVE_TABLE[ATA$FIT_TIMING(t.active, 1, 16, 1)];
		if (CMD_REVISION(a) <= FLAGS_CMD_640_NO_DMA) {
			recover = RECOVER_640_TABLE[ATA$FIT_TIMING(t.recover, 2, 17, 2)];
		} else {
			recover = RECOVER_TABLE[ATA$FIT_TIMING(t.recover, 1, 16, 1)];
		}
		CMD_WRITE_CONFIG_BYTE(a, PIOREG_TABLE[(p->n << 1) | drive], active | recover);
	}
	if (CMD_REVISION(a) >= FLAGS_CMD_646_NO_UDMA) {
		__u8 udma_reg = UDMAREG_TABLE[p->n];
		__u8 udma_val = CMD_READ_CONFIG_BYTE(a, udma_reg);
		unsigned udma = p->xfer_mode[1][drive] - (N_SDMA_MODES + N_WDMA_MODES);
		udma_val &= ~(((CMD_UIDETCR0_PRI_MASTER_UDMA | CMD_UIDETCR0_PRI_MASTER_CLKRES) << drive) | (CMD_UIDETCR0_PRI_MASTER_CLK << (drive << 1)));
		if (udma <= 5) {
			udma_val |= CMD_UIDETCR0_PRI_MASTER_UDMA << drive;
			udma_val |= UDMA_TABLE1[udma] << (drive << 1);
			udma_val |= UDMA_TABLE2[udma] << drive;
		}
		CMD_WRITE_CONFIG_BYTE(a, udma_reg, udma_val);
	}
	if (CMD_REVISION(a) > FLAGS_CMD_640_NO_DMA) {
		__u8 dma_reg = DMAREG_TABLE[p->n];
		__u8 dma_val = CMD_READ_CONFIG_BYTE(a, dma_reg);
		dma_val &= ~(CMD_BMIDESR0_MASTER_DMA_CAP << drive);
		if (p->xfer_mode[1][drive] < N_DMA_MODES)
			dma_val |= CMD_BMIDESR0_MASTER_DMA_CAP << drive;
		CMD_WRITE_CONFIG_BYTE(a, dma_reg, dma_val);
	}
	{
		__u8 pref_reg = PREFREG_TABLE[(p->n << 1) | drive];
		__u8 pref_bit = PREFBIT_TABLE[(p->n << 1) | drive];
		__u8 pref_val = CMD_READ_CONFIG_BYTE(a, pref_reg);
		if (!atapi)
			pref_val |= pref_bit;
		else
			pref_val &= ~pref_bit;
		CMD_WRITE_CONFIG_BYTE(a, pref_reg, pref_val);
	}
	return 0;
}

static __u8 CMD_STOP_DMA(APORT *p, __u8 mask)
{
	ACTRL *a;
	__u8 dmastatus = io_inb(p->dma_io + DMAPORT_STATUS);
	if (__unlikely(!(dmastatus & mask)) && __likely(mask)) return dmastatus;
	stop_dma_generic(p, dmastatus);
	a = p->ctrl;
	if (__likely(!p->n)) {
		__u8 val = PCI$READ_CONFIG_BYTE(a->pci_id, CMD_CFR);
		PCI$WRITE_CONFIG_BYTE(a->pci_id, CMD_CFR, val | CMD_CFR_PRI_IRQ);
	} else {
		__u8 val = PCI$READ_CONFIG_BYTE(a->pci_id, CMD_ARTTIM23);
		PCI$WRITE_CONFIG_BYTE(a->pci_id, CMD_ARTTIM23, val | CMD_ARTTIM23_SEC_IRQ);
	}
	return dmastatus;
}
