#include <SPAD/SYSLOG.H>
#include <SPAD/ATA.H>

#include "ACTRLREG.H"
#include "ACTRL.H"

#define JMB_PORT_PATA0	1
#define JMB_PORT_PATA1	2
#define JMB_PORT_SATA	4

static void JMB_PATA_GET_AVAIL_XFER(APORT *p, int drive, const __u16 ident[256], unsigned *avail, unsigned *avail_unsupported);

int DETECT_JMB(ACTRL *a)
{
	int i;

	__u32 cw_40, cw_80;

	if ((a->dev_id & 0xffff) != 0x197b) return 0;

	if (!a->chipset_name) a->chipset_name = "JMB";

	cw_40 = PCI$READ_CONFIG_DWORD(a->pci_id, 0x40);
	cw_80 = PCI$READ_CONFIG_DWORD(a->pci_id, 0x80);
	if (cw_40 & (1 << 23)) {
		a->port[0].port_chipset_flags = JMB_PORT_SATA;
		a->port[1].port_chipset_flags = JMB_PORT_PATA0;
	} else {
		a->port[0].port_chipset_flags = JMB_PORT_SATA;
		a->port[1].port_chipset_flags = JMB_PORT_SATA;
	}
	if (cw_80 & (1 << 24)) {
		a->port[0].port_chipset_flags = JMB_PORT_PATA1;
	}
	if (cw_40 & (1 << 24)) {
		unsigned long pcf = a->port[0].port_chipset_flags;
		a->port[0].port_chipset_flags = a->port[1].port_chipset_flags;
		a->port[1].port_chipset_flags = pcf;
	}

	for (i = 0; i < a->n_ports; i++) {
		if (a->port[i].port_chipset_flags & JMB_PORT_SATA) {
			a->port[i].aport_flags |= APORT_SATA;
		} else {
			a->port[i].get_avail_xfer = JMB_PATA_GET_AVAIL_XFER;
			a->port[i].set_xfer = ATA$SET_XFER_EMPTY;
		}
	}

	return 1;
}

static void JMB_PATA_GET_AVAIL_XFER(APORT *p, int drive, const __u16 ident[256], unsigned *avail, unsigned *avail_unsupported)
{
	__u32 cw_40;
	int bit;

	*avail = IDE_XFER_PIO_0 |
		 IDE_XFER_PIO_1 |
		 IDE_XFER_PIO_2 |
		 IDE_XFER_PIO_3 |
		 IDE_XFER_PIO_4 |
		 IDE_XFER_PIO_5 |
		 IDE_XFER_WDMA_0 |
		 IDE_XFER_WDMA_1 |
		 IDE_XFER_WDMA_2 |
		 IDE_XFER_UDMA_0 |
		 IDE_XFER_UDMA_1 |
		 IDE_XFER_UDMA_2 |
		 IDE_XFER_UDMA_3 |
		 IDE_XFER_UDMA_4 |
		 IDE_XFER_UDMA_5 |
		 IDE_XFER_UDMA_6;
	*avail_unsupported = 0;

	cw_40 = PCI$READ_CONFIG_DWORD(p->ctrl->pci_id, 0x40);
	bit = p->port_chipset_flags & JMB_PORT_PATA0 ? 3 : 19;
	if (cw_40 & (1 << bit))
		ATA$CABLE40_RESTRICT(avail, avail_unsupported);
}
