#include "ACTRL.H"

#define SII_IDX		5
#define SII_REGSPACE	256

#define SII_PCI_CONFIG		0x40
#define  SII_PCI_CONFIG_HDRWQ		0x00000001
#define SII_PCI_SW_DATA		0x44
#define SII_PCI_PM_CAP		0x60
#define SII_PCI_PM_CTL		0x64
#define SII_PCI_IDE0_BUS_MASTER	0x70
#define SII_PCI_IDE0_PRD	0x74
#define SII_PCI_IDE1_BUS_MASTER	0x78
#define SII_PCI_IDE1_PRD	0x7c
#define SII_PCI_IDE0_XFER_MODE	0x80
#define SII_PCI_IDE1_XFER_MODE	0x84
#define  SII_PCI_IDE_XFER_MODE_DEV0	0x00000003
#define   SII_PCI_IDE_XFER_MODE_DEV0_PIO_NIO	0x00000000
#define   SII_PCI_IDE_XFER_MODE_DEV0_PIO_IORDY	0x00000001
#define   SII_PCI_IDE_XFER_MODE_DEV0_DMA	0x00000002
#define   SII_PCI_IDE_XFER_MODE_DEV0_UDMA	0x00000003
#define  SII_PCI_IDE_XFER_MODE_DEV1	0x00000030
#define   SII_PCI_IDE_XFER_MODE_DEV1_PIO_NIO	0x00000000
#define   SII_PCI_IDE_XFER_MODE_DEV1_PIO_IORDY	0x00000010
#define   SII_PCI_IDE_XFER_MODE_DEV1_DMA	0x00000020
#define   SII_PCI_IDE_XFER_MODE_DEV1_UDMA	0x00000030
#define SII_PCI_SYS_CONF	0x88
#define  SII_PCI_SYS_CONF_PBM_RST	0x00000001
#define  SII_PCI_SYS_CONF_ARB_RST	0x00000002
#define  SII_PCI_SYS_CONF_FF1_RST	0x00000010
#define  SII_PCI_SYS_CONF_FF0_RST	0x00000020
#define  SII_PCI_SYS_CONF_IDE1_RST	0x00000040
#define  SII_PCI_SYS_CONF_IDE0_RST	0x00000080
#define  SII_PCI_SYS_CONF_BA5_EN	0x00010000
#define  SII_PCI_SYS_CONF_IDE_CLK	0x00300000
#define   SII_PCI_SYS_CONF_IDE_CLK_100		0x00000000
#define   SII_PCI_SYS_CONF_IDE_CLK_133		0x00100000
#define   SII_PCI_SYS_CONF_IDE_CLK_PCI2		0x00200000
#define   SII_PCI_SYS_CONF_IDE_CLK_DIS		0x00300000
#define  SII_PCI_SYS_CONF_IDE1_INT_BLK	0x00400000
#define  SII_PCI_SYS_CONF_IDE0_INT_BLK	0x00800000
#define SII_PCI_SYS_SW_DATA	0x8c
#define SII_PCI_FLASH_ADDRESS	0x90
#define SII_PCI_FLASH_DATA	0x94
#define SII_PCI_EEPROM_ADDRESS	0x98
#define SII_PCI_EEPROM_DATA	0x9c
#define SII_PCI_IDE0_T_TASK	0xa0
#define SII_PCI_IDE0_T_PIO	0xa4
#define SII_PCI_IDE0_T_DMA	0xa8
#define SII_PCI_IDE0_T_UDMA	0xac
#define SII_PCI_IDE1_T_TASK	0xb0
#define SII_PCI_IDE1_T_PIO	0xb4
#define SII_PCI_IDE1_T_DMA	0xb8
#define SII_PCI_IDE1_T_UDMA	0xbc
#define  IDE_T_TASK_CABLE_80		0x00000001
#define  IDE_T_TASK_BUF_CMD		0x00000002
#define  IDE_T_TASK_CHAN_RST		0x00000004
#define  IDE_T_TASK_CHAN_3STATE		0x00000008
#define  IDE_T_TASK_IORDY		0x00000200
#define  IDE_T_TASK_VDMA_INT		0x00000400
#define  IDE_T_TASK_INT			0x00000800
#define  IDE_T_TASK_WD_TIMEOUT		0x00001000
#define  IDE_T_TASK_WD_ENA		0x00002000
#define  IDE_T_TASK_WD_INT_ENA		0x00004000
#define  IDE_T_TASK_RECOVERY_COUNT	0x003f0000
#define  IDE_T_TASK_ACTIVE_COUNT	0x0fc00000
#define  IDE_T_TASK_AST_COUNT		0xf0000000
#define  IDE_T_PIO_DEV0_RECOVERY_COUNT	0x0000003f
#define  IDE_T_PIO_DEV0_ACTIVE_COUNT	0x00000fc0
#define  IDE_T_PIO_DEV0_AST_COUNT	0x0000f000
#define  IDE_T_PIO_DEV1_RECOVERY_COUNT	0x003f0000
#define  IDE_T_PIO_DEV1_ACTIVE_COUNT	0x0fc00000
#define  IDE_T_PIO_DEV1_AST_COUNT	0xf0000000
#define  IDE_T_DMA_DEV0_RECOVERY_COUNT	0x0000003f
#define  IDE_T_DMA_DEV0_ACTIVE_COUNT	0x00000fc0
#define  IDE_T_DMA_DEV0_AST_COUNT	0x0000f000
#define  IDE_T_DMA_DEV1_RECOVERY_COUNT	0x003f0000
#define  IDE_T_DMA_DEV1_ACTIVE_COUNT	0x0fc00000
#define  IDE_T_DMA_DEV1_AST_COUNT	0xf0000000
#define  IDE_T_UDMA_DEV0_CYCLE_COUNT	0x0000003f
#define  IDE_T_UDMA_DEV0_HSTROBE_DELAY	0x00000e00
#define  IDE_T_UDMA_DEV0_DSTROBE_DELAY	0x00003000
#define  IDE_T_UDMA_DEV0_DINPUT_DELAY	0x0000c000
#define  IDE_T_UDMA_DEV1_CYCLE_COUNT	0x003f0000
#define  IDE_T_UDMA_DEV1_HSTROBE_DELAY	0x0e000000
#define  IDE_T_UDMA_DEV1_DSTROBE_DELAY	0x30000000
#define  IDE_T_UDMA_DEV1_DINPUT_DELAY	0xc0000000

#define SII_IDE0_DMA_CMD	0x00
#define  SII_IDE_DMA_CMD_INTR_STEERING	0x00000002
#define SII_SW_DATA		0x01
#define SII_IDE0_DMA_STATUS	0x02
#define SII_IDE0_PRD		0x04
#define SII_IDE1_DMA_CMD	0x08
#define SII_IDE1_DMA_STATUS	0x0a
#define SII_IDE1_PRD		0x0c
#define SII_IDE0_DMA_CMD2	0x10
#define  SII_IDE0_DMA_CMD2_PBM_ENABLE	0x00000001
#define  SII_IDE0_DMA_CMD2_PBM_RDWR	0x00000004
#define  SII_IDE0_DMA_CMD2_SW_CLR_D0_D2	0x00000300
#define  SII_IDE0_DMA_CMD2_SW_CLR_RST	0x00000c00
#define  SII_IDE0_DMA_CMD2_SW_NOT_CLR	0x00003000
#define  SII_IDE0_DMA_CMD2_PBM_INT1	0x00004000
#define  SII_IDE0_DMA_CMD2_WD_TIMEOUT01	0x00008000
#define  SII_IDE0_DMA_CMD2_PBM_ACTIVE	0x00010000
#define  SII_IDE0_DMA_CMD2_PBM_ERROR	0x00020000
#define  SII_IDE0_DMA_CMD2_PBM_INT	0x00040000
#define  SII_IDE0_DMA_CMD2_FIFO_EMPTY	0x00080000
#define  SII_IDE0_DMA_CMD2_WD_TIMEOUT	0x00100000
#define  SII_IDE0_DMA_CMD2_PBM_CAP0	0x00200000
#define  SII_IDE0_DMA_CMD2_PBM_CAP1	0x00400000
#define  SII_IDE0_DMA_CMD2_PBM_SIMPLEX	0x00800000
#define  SII_IDE0_DMA_CMD2_PBM_ACTIVE1	0x01000000
#define  SII_IDE0_DMA_CMD2_PBM_ERROR1	0x02000000
#define  SII_IDE0_DMA_CMD2_PBM_INT1_2	0x04000000
#define  SII_IDE0_DMA_CMD2_WD_TIMEOUT1	0x08000000
#define  SII_IDE0_DMA_CMD2_FIFO_EMPTY1	0x10000000
#define  SII_IDE0_DMA_CMD2_PBM_CAP01	0x20000000
#define  SII_IDE0_DMA_CMD2_PBM_CAP11	0x40000000
#define  SII_IDE0_DMA_CMD2_PBM_SIMPLEX1	0x80800000
#define SII_IDE1_DMA_CMD2	0x18
#define  SII_IDE1_DMA_CMD2_PBM_ENABLE	0x00000001
#define  SII_IDE1_DMA_CMD2_PBM_RDWR	0x00000004
#define  SII_IDE1_DMA_CMD2_PBM_ACTIVE	0x00010000
#define  SII_IDE1_DMA_CMD2_PBM_ERROR	0x00020000
#define  SII_IDE1_DMA_CMD2_PBM_INT	0x00040000
#define  SII_IDE1_DMA_CMD2_FIFO_EMPTY	0x00080000
#define  SII_IDE1_DMA_CMD2_WD_TIMEOUT	0x00100000
#define  SII_IDE1_DMA_CMD2_PBM_CAP0	0x00200000
#define  SII_IDE1_DMA_CMD2_PBM_CAP1	0x00400000
#define  SII_IDE1_DMA_CMD2_PBM_SIMPLEX	0x00800000
#define SII_IDE0_PRD_ADDRESS	0x20
#define SII_IDE0_PRD_COUNT	0x24
#define SII_IDE1_PRD_ADDRESS	0x28
#define SII_IDE1_PRD_COUNT	0x2c
#define SII_IDE0_FIFO		0x40
#define SII_IDE1_FIFO		0x44
#define  SII_IDE_FIFO_RD_REQ		0x0000003f
#define  SII_IDE_FIFO_WR_REQ		0x00003f00
#define  SII_IDE_FIFO_BYTE_COUNT	0x01f00000
#define SII_SYS_CONF		0x48
#define SII_SYS_SW_DATA		0x4c
#define SII_FLASH_ADDRESS	0x50
#define SII_FLASH_DATA		0x54
#define SII_EEPROM_ADDRESS	0x58
#define SII_EEPROM_DATA		0x5c
#define SII_IDE0_FIFO_DATA	0x60
#define SII_IDE0_FIFO_POINTERS	0x68
#define SII_IDE0_FIFO_POINTERS2	0x6c
#define SII_IDE1_FIFO_DATA	0x70
#define SII_IDE1_FIFO_POINTERS	0x78
#define SII_IDE1_FIFO_POINTERS2	0x7c
#define SII_IDE0_DATA		0x80
#define SII_IDE0_FEATURES	0x81
#define SII_IDE0_ERROR		0x82
#define SII_IDE0_COUNT		0x83
#define SII_IDE0_LBA_L		0x84
#define SII_IDE0_LBA_M		0x85
#define SII_IDE0_LBA_H		0x86
#define SII_IDE0_CMD		0x87
#define SII_IDE0_STATUS		0x87
#define SII_IDE0_ALT_STATUS	0x8a
#define SII_IDE0_CTRL		0x8a
#define SII_IDE0_READ_AHEAD	0x8c
#define SII_IDE0_BUF_DATA	0x90
#define SII_IDE0_BUF_FEATURES	0x91
#define SII_IDE0_BUF_ERROR	0x92
#define SII_IDE0_BUF_COUNT	0x93
#define SII_IDE0_BUF_LBA_L	0x94
#define SII_IDE0_BUF_LBA_M	0x95
#define SII_IDE0_BUF_LBA_H	0x96
#define SII_IDE0_BUF_CMD	0x97
#define SII_IDE0_BUF_STATUS	0x97
#define SII_IDE0_UDMA_RESERVED	0x98
#define SII_IDE0_PIO_VDMA_COUNT	0x9c
#define SII_IDE0_T_TASK		0xa0
#define SII_IDE0_T_PIO		0xa4
#define SII_IDE0_T_DMA		0xa8
#define SII_IDE0_T_UDMA		0xac
#define SII_IDE0_TEST		0xb0
#define SII_IDE0_XFER_MODE	0xb4
#define SII_IDE1_DATA		0xc0
#define SII_IDE1_FEATURES	0xc1
#define SII_IDE1_ERROR		0xc2
#define SII_IDE1_COUNT		0xc3
#define SII_IDE1_LBA_L		0xc4
#define SII_IDE1_LBA_M		0xc5
#define SII_IDE1_LBA_H		0xc6
#define SII_IDE1_CMD		0xc7
#define SII_IDE1_STATUS		0xc7
#define SII_IDE1_ALT_STATUS	0xca
#define SII_IDE1_CTRL		0xca
#define SII_IDE1_READ_AHEAD	0xcc
#define SII_IDE1_BUF_DATA	0xd0
#define SII_IDE1_BUF_FEATURES	0xd1
#define SII_IDE1_BUF_ERROR	0xd2
#define SII_IDE1_BUF_COUNT	0xd3
#define SII_IDE1_BUF_LBA_L	0xd4
#define SII_IDE1_BUF_LBA_M	0xd5
#define SII_IDE1_BUF_LBA_H	0xd6
#define SII_IDE1_BUF_CMD	0xd7
#define SII_IDE1_BUF_STATUS	0xd7
#define SII_IDE1_UDMA_RESERVED	0xd8
#define SII_IDE1_PIO_VDMA_COUNT	0xdc
#define SII_IDE1_T_TASK		0xe0
#define SII_IDE1_T_PIO		0xe4
#define SII_IDE1_T_DMA		0xe8
#define SII_IDE1_T_UDMA		0xec
#define SII_IDE1_TEST		0xf0
#define SII_IDE1_XFER_MODE	0xf4
#define SII_SATA0_SCONTROL	0x100
#define SII_SATA0_SSTATUS	0x104
#define SII_SATA0_SERROR	0x108
#define SII_SATA0_SACTIVE	0x10c
#define SII_SATA0_SMISC		0x140
#define SII_SATA0_SPHY		0x144
#define SII_SATA0_SIEN		0x148
#define SII_SATA0_SFISCFG	0x14c
#define SII_SATA0_RXFIS0	0x160
#define SII_SATA0_RXFIS1	0x164
#define SII_SATA0_RXFIS2	0x168
#define SII_SATA0_RXFIS3	0x16c
#define SII_SATA0_RXFIS4	0x170
#define SII_SATA0_RXFIS5	0x174
#define SII_SATA0_RXFIS6	0x178
#define SII_SATA1_SCONTROL	0x180
#define SII_SATA1_SSTATUS	0x184
#define SII_SATA1_SERROR	0x188
#define SII_SATA1_SACTIVE	0x18c
#define SII_SATA1_SMISC		0x1c0
#define SII_SATA1_SPHY		0x1c4
#define SII_SATA1_SIEN		0x1c8
#define SII_SATA1_SFISCFG	0x1cc
#define SII_SATA1_RXFIS0	0x1e0
#define SII_SATA1_RXFIS1	0x1e4
#define SII_SATA1_RXFIS2	0x1e8
#define SII_SATA1_RXFIS3	0x1ec
#define SII_SATA1_RXFIS4	0x1f0
#define SII_SATA1_RXFIS5	0x1f4
#define SII_SATA1_RXFIS6	0x1f8
#define SII_PORT23		0x200

static const __u16 fifo_cfg[4] = { SII_IDE0_FIFO, SII_IDE1_FIFO, SII_PORT23 + SII_IDE0_FIFO, SII_PORT23 + SII_IDE1_FIFO };
static const __u16 sfis_cfg[4] = { SII_SATA0_SFISCFG, SII_SATA1_SFISCFG, SII_PORT23 + SII_SATA0_SFISCFG, SII_PORT23 + SII_SATA1_SFISCFG };


#define FLAGS2_CLOCK		0x00000003
#define FLAGS2_CLOCK_100		0x00000000
#define FLAGS2_CLOCK_133		0x00000001
#define FLAGS2_CLOCK_66			0x00000002
#define FLAGS2_CLOCK_NO			0x00000003

#define PORT_FLAG_LIMIT_15_WRITES	1

static void SII_PATA_GET_AVAIL_XFER(APORT *p, int drive, const __u16 ident[256], unsigned *avail, unsigned *avail_unsupported);
static int SII_PATA_SET_XFER(APORT *p, int drive, unsigned mode, const __u16 id[256]);
static void SII_SATA_GET_AVAIL_XFER(APORT *p, int drive, const __u16 ident[256], unsigned *avail, unsigned *avail_unsupported);
static void SII_DTOR(ACTRL *a);

int DETECT_SII(ACTRL *a)
{
	int real_ports = 2;
	int sata;
	int i;
	void *res;
	__u32 sys_conf;
	switch (a->dev_id) {
		case 0x06801095:
			sata = 0;
			break;
		case 0x31141095:
			real_ports = 4;
		case 0x31121095:
		case 0x02491095:
		case 0x35121095:
		case 0x436e1002:
		case 0x43791002:
		case 0x437a1002:
			sata = 1;
			break;
		default:
			return 0;
	}
	PCI$ENABLE_DEVICE(a->pci_id, PCI_COMMAND_MEMORY);
	res = PCI$MAP_MEM_RESOURCE(a->pci_id, SII_IDX, SII_REGSPACE);
	if (res && !__IS_ERR(res)) {
		a->chipset_flags = (unsigned long)res;
	} else {
		a->chipset_flags = 0;
	}
	a->chipset_dtor = SII_DTOR;

	if (!sata) {
		sys_conf = PCI$READ_CONFIG_DWORD(a->pci_id, SII_PCI_SYS_CONF);
		if ((sys_conf & SII_PCI_SYS_CONF_IDE_CLK) != SII_PCI_SYS_CONF_IDE_CLK_133) {
			sys_conf &= ~SII_PCI_SYS_CONF_IDE_CLK;
			sys_conf |= SII_PCI_SYS_CONF_IDE_CLK_133;
			PCI$WRITE_CONFIG_DWORD(a->pci_id, SII_PCI_SYS_CONF, sys_conf);
			sys_conf = PCI$READ_CONFIG_DWORD(a->pci_id, SII_PCI_SYS_CONF);
		}
		switch (sys_conf & SII_PCI_SYS_CONF_IDE_CLK) {
			case SII_PCI_SYS_CONF_IDE_CLK_100:
				a->chipset_flags_2 |= FLAGS2_CLOCK_100;
				break;
			case SII_PCI_SYS_CONF_IDE_CLK_133:
				a->chipset_flags_2 |= FLAGS2_CLOCK_133;
				break;
			case SII_PCI_SYS_CONF_IDE_CLK_PCI2:
				a->chipset_flags_2 |= FLAGS2_CLOCK_66;
				break;
			case SII_PCI_SYS_CONF_IDE_CLK_DIS:
				a->chipset_flags_2 |= FLAGS2_CLOCK_NO;
				break;
		}
	} else {
		if (a->chipset_flags) {
			__u8 cls = PCI$READ_CONFIG_BYTE(a->pci_id, PCI_CACHE_LINE_SIZE);
			if (cls) {
				cls = (cls / 8) + 1;
				for (i = 0; i < real_ports; i++) {
					mmio_outw((__u8 *)a->chipset_flags + fifo_cfg[i], (cls << __BSF_CONST(SII_IDE_FIFO_RD_REQ)) | (cls << __BSF_CONST(SII_IDE_FIFO_WR_REQ)));
				}
			}
			if (a->dev_id == 0x35121095 || a->dev_id == 0x31141095) {
				for (i = 0; i < real_ports; i++) {
					__u32 sfcfg = mmio_inl((__u8 *)a->chipset_flags + sfis_cfg[i]);
					if ((sfcfg & 3) != 1) continue;
					sfcfg &= ~3;
					mmio_outl((__u8 *)a->chipset_flags + sfis_cfg[i], sfcfg);
				}
			}
			if (real_ports == 4) {
		/* simultaneous 4-port operation not supported now */
				__u32 bd = mmio_inl((__u8 *)a->chipset_flags + SII_IDE0_DMA_CMD + SII_PORT23);
				bd &= ~SII_IDE_DMA_CMD_INTR_STEERING;
				mmio_outl((__u8 *)a->chipset_flags + SII_IDE0_DMA_CMD + SII_PORT23, bd);
			}
		}
	}

	for (i = 0; i < a->n_ports; i++) {
		if (!sata) {
			a->port[i].get_avail_xfer = SII_PATA_GET_AVAIL_XFER;
			a->port[i].set_xfer = SII_PATA_SET_XFER;
		} else {
			a->port[i].get_avail_xfer = SII_SATA_GET_AVAIL_XFER;
		}
		a->port[i].xfer_mode[0][0] = 0xff;
		a->port[i].xfer_mode[0][1] = 0xff;
		a->port[i].xfer_mode[1][0] = 0xff;
		a->port[i].xfer_mode[1][1] = 0xff;
	}

	return 1;
}

static void SII_PATA_GET_AVAIL_XFER(APORT *p, int drive, const __u16 ident[256], unsigned *avail, unsigned *avail_unsupported)
{
	*avail = 0;
	*avail_unsupported = 0;
	switch (p->ctrl->chipset_flags_2 & FLAGS2_CLOCK) {
		case FLAGS2_CLOCK_133:
			*avail |= IDE_XFER_UDMA_6;
		case FLAGS2_CLOCK_100:
			*avail |= IDE_XFER_UDMA_5;
		case FLAGS2_CLOCK_66:
			*avail |= IDE_XFER_UDMA_0 | IDE_XFER_UDMA_1 | IDE_XFER_UDMA_2 | IDE_XFER_UDMA_3 | IDE_XFER_UDMA_4;
		default:
			*avail |= IDE_XFER_PIO_0 | IDE_XFER_PIO_1 | IDE_XFER_PIO_2 | IDE_XFER_PIO_3 | IDE_XFER_PIO_4 | IDE_XFER_PIO_5 | IDE_XFER_PIO_6 | IDE_XFER_WDMA_0 | IDE_XFER_WDMA_1 | IDE_XFER_WDMA_2 | IDE_XFER_WDMA_3 | IDE_XFER_WDMA_4;
	}
	if (!(PCI$READ_CONFIG_BYTE(p->ctrl->pci_id, SII_PCI_IDE0_T_TASK + 16 * p->n) & IDE_T_TASK_CABLE_80))
		ATA$CABLE40_RESTRICT(avail, avail_unsupported);
}

static int SII_PATA_SET_XFER(APORT *p, int drive, unsigned mode, const __u16 id[256])
{
	ACTRL *a = p->ctrl;
	struct ata_timing t1;
	struct ata_timing t2;
	unsigned udma_clock;
	unsigned reg, mode_reg, want_mode;
	ATA$INIT_TIMING(&t1);
	if (mode & IDE_XFER_MASK_PIO) {
		p->xfer_mode[0][drive] = ATA$XFER_GET_NUMBER(mode, IDE_XFER_MASK_PIO);
		ATA$MERGE_PIO_TIMING(&t1, p->xfer_mode[0][drive], ATA_MERGE_ALL);
	} else {
		p->xfer_mode[1][drive] = ATA$XFER_GET_NUMBER(mode, IDE_XFER_MASK_DMA);
		ATA$MERGE_DMA_TIMING(&t1, p->xfer_mode[1][drive], ATA_MERGE_ALL);
	}
	ATA$INIT_TIMING(&t2);
	ATA$MERGE_TIMING(&t2, &t1, ATA_MERGE_ALL);
	ATA$MERGE_PIO_TIMING(&t2, p->xfer_mode[0][drive ^ 1], ATA_MERGE_8BIT | ATA_MERGE_SETUP);
	switch (p->ctrl->chipset_flags_2 & FLAGS2_CLOCK) {
		case FLAGS2_CLOCK_133:
			udma_clock = 133333;
			break;
		case FLAGS2_CLOCK_100:
			udma_clock = 100000;
			break;
		case FLAGS2_CLOCK_66:
			udma_clock = a->bus_clock * 2;
			break;
		default:
			udma_clock = 0;
			break;
	}
	ATA$QUANTIZE_TIMING(&t1, a->bus_clock, udma_clock);
	ATA$QUANTIZE_TIMING(&t2, a->bus_clock, udma_clock);
	if (mode & IDE_XFER_MASK_PIO) {
		reg = SII_PCI_IDE0_T_PIO;
	} else if (mode & IDE_XFER_MASK_WDMA) {
		reg = SII_PCI_IDE0_T_DMA;
	} else {
		reg = SII_PCI_IDE0_T_UDMA;
	}
	reg += p->n * 16 + drive * 2;
	if (mode & (IDE_XFER_MASK_PIO | IDE_XFER_MASK_WDMA)) {
		if (t1.setup && t1.active && t1.recover) {
			PCI$WRITE_CONFIG_WORD(a->pci_id, reg,
				(ATA$FIT_TIMING(t1.setup, 1, IDE_T_PIO_DEV0_AST_COUNT >> __BSF_CONST(IDE_T_PIO_DEV0_AST_COUNT), 0) << __BSF_CONST(IDE_T_PIO_DEV0_AST_COUNT)) |
				(ATA$FIT_TIMING(t1.active, 1, IDE_T_PIO_DEV0_ACTIVE_COUNT >> __BSF_CONST(IDE_T_PIO_DEV0_ACTIVE_COUNT), 0) << __BSF_CONST(IDE_T_PIO_DEV0_ACTIVE_COUNT)) |
				(ATA$FIT_TIMING(t1.recover, 1, IDE_T_PIO_DEV0_RECOVERY_COUNT >> __BSF_CONST(IDE_T_PIO_DEV0_RECOVERY_COUNT), 0) << __BSF_CONST(IDE_T_PIO_DEV0_RECOVERY_COUNT))
			);
		}
	}
	if (mode & IDE_XFER_MASK_UDMA) {
		if (t1.udma) {
			__u16 udma = PCI$READ_CONFIG_WORD(a->pci_id, reg);
			udma &= ~IDE_T_UDMA_DEV0_CYCLE_COUNT;
			udma |= ATA$FIT_TIMING(t1.udma, 2, (IDE_T_UDMA_DEV0_CYCLE_COUNT >> __BSF_CONST(IDE_T_UDMA_DEV0_CYCLE_COUNT)) + 1, 1) << __BSF_CONST(IDE_T_UDMA_DEV0_CYCLE_COUNT);
			PCI$WRITE_CONFIG_WORD(a->pci_id, reg, udma);
		}
	}
	if (mode & IDE_XFER_MASK_PIO) {
		reg = SII_PCI_IDE0_T_TASK + 2 + 16 * p->n;
		if (t2.setup && t2.act8b && t2.rec8b) {
			PCI$WRITE_CONFIG_WORD(a->pci_id, reg,
				(ATA$FIT_TIMING(t2.setup, 1, IDE_T_PIO_DEV0_AST_COUNT >> __BSF_CONST(IDE_T_PIO_DEV0_AST_COUNT), 0) << __BSF_CONST(IDE_T_PIO_DEV0_AST_COUNT)) |
				(ATA$FIT_TIMING(t2.act8b, 1, IDE_T_PIO_DEV0_ACTIVE_COUNT >> __BSF_CONST(IDE_T_PIO_DEV0_ACTIVE_COUNT), 0) << __BSF_CONST(IDE_T_PIO_DEV0_ACTIVE_COUNT)) |
				(ATA$FIT_TIMING(t2.rec8b, 1, IDE_T_PIO_DEV0_RECOVERY_COUNT >> __BSF_CONST(IDE_T_PIO_DEV0_RECOVERY_COUNT), 0) << __BSF_CONST(IDE_T_PIO_DEV0_RECOVERY_COUNT))
			);
		}
	}
	reg = SII_PCI_IDE0_XFER_MODE + p->n * 4;
	mode_reg = PCI$READ_CONFIG_BYTE(a->pci_id, reg);
	if (p->xfer_mode[1][drive] < N_SDMA_MODES + N_WDMA_MODES) {
		want_mode = SII_PCI_IDE_XFER_MODE_DEV0_DMA;
	} else if (p->xfer_mode[1][drive] < N_DMA_MODES) {
		want_mode = SII_PCI_IDE_XFER_MODE_DEV0_UDMA;
	} else if (p->xfer_mode[0][drive] <= 2 || p->xfer_mode[0][drive] >= N_PIO_MODES) {
		want_mode = SII_PCI_IDE_XFER_MODE_DEV0_PIO_NIO;
	} else {
		want_mode = SII_PCI_IDE_XFER_MODE_DEV0_PIO_IORDY;
	}
	if (((mode_reg >> (drive * 4)) & SII_PCI_IDE_XFER_MODE_DEV0) != want_mode) {
		mode_reg &= ~(SII_PCI_IDE_XFER_MODE_DEV0 << (drive * 4));
		mode_reg |= want_mode << (drive * 4);
		PCI$WRITE_CONFIG_BYTE(a->pci_id, reg, mode_reg);
	}
	return 0;
}

static void SII_SATA_LIMIT_15_WRITES(APORT *p, ATARQ *rq);

static const char * const WRITE_LIMIT_MODELS[] = {
	"ST320012AS",
	"ST330013AS",
	"ST340017AS",
	"ST360015AS",
	"ST380023AS",
	"ST3120023AS",
	"ST340014ASL",
	"ST360014ASL",
	"ST380011ASL",
	"ST3120022ASL",
	"ST3160021ASL",
	NULL
};

static void SII_SATA_GET_AVAIL_XFER(APORT *p, int drive, const __u16 ident[256], unsigned *avail, unsigned *avail_unsupported)
{
	ACTRL *a = p->ctrl;
	SATA_GET_AVAIL_XFER(p, drive, ident, avail, avail_unsupported);
	if (ATA$IS_ATAPI(ident)) {
		/* In Linux it works, for me it doesn't. */
		*avail &= ~IDE_XFER_MASK_DMA;
		*avail_unsupported &= ~IDE_XFER_MASK_DMA;
		return;
	}
	*avail_unsupported = *avail & IDE_XFER_UDMA_6;
	*avail &= ~IDE_XFER_UDMA_6;
	if (a->dev_id == 0x31121095 ||
	    a->dev_id == 0x02491095 ||
	    a->dev_id == 0x436e1002 ||
	    a->dev_id == 0x43791002 ||
	    a->dev_id == 0x437a1002) {
		if (ATA$BLACKLIST_SEARCH(WRITE_LIMIT_MODELS, ident)) {
			p->mangle = SII_SATA_LIMIT_15_WRITES;
			p->aport_flags |= APORT_MANGLE_REQUEST;
			p->port_chipset_flags |= PORT_FLAG_LIMIT_15_WRITES << drive;
		} else {
			p->port_chipset_flags &= ~(PORT_FLAG_LIMIT_15_WRITES << drive);
		}
	}
}

static void SII_SATA_LIMIT_15_WRITES(APORT *p, ATARQ *rq)
{
	if (__likely((rq->atarq_flags & (ATARQ_TO_DEVICE | ATARQ_SET_SIZE)) != (ATARQ_TO_DEVICE | ATARQ_SET_SIZE)))
		return;
	if (__unlikely(!(p->port_chipset_flags & (PORT_FLAG_LIMIT_15_WRITES << rq->device))))
		return;
	if (__likely(rq->len > 15 << BIO_SECTOR_SIZE_BITS))
		rq->len = 15 << BIO_SECTOR_SIZE_BITS;
}

static void SII_DTOR(ACTRL *a)
{
	if (a->chipset_flags)
		PCI$UNMAP_MEM_RESOURCE(a->pci_id, (void *)a->chipset_flags, SII_REGSPACE);
}
