#include <SPAD/PCI.H>

#include "ACTRL.H"

static int INIT_ULI(ACTRL *a);

int DETECT_ULI_4PORT(pci_id_t pci_id, int (**special_init)(ACTRL *a))
{
	__u32 dev_id = PCI$READ_CONFIG_DWORD(pci_id, PCI_VENDOR_ID);
	if (dev_id != 0x528710b9)
		return 0;
	*special_init = INIT_ULI;
	return 4;
}

static int INIT_ULI(ACTRL *a)
{
	int i;
	int irq = PCI$READ_INTERRUPT_LINE(a->pci_id);
	for (i = 0; i < a->n_ports; i++) {
		io_t base_port, alt_port, dma_port;
		base_port = PCI$READ_IO_RESOURCE(a->pci_id, (i & 1) * 2);
		alt_port = PCI$READ_IO_RESOURCE(a->pci_id, 1 + (i & 1) * 2);
		dma_port = PCI$READ_IO_RESOURCE(a->pci_id, 4);
		if (!base_port || !alt_port) {
			a->port[i].aport_flags = APORT_DISABLED;
			continue;
		}
		if (i & 2) {
			base_port += 8;
			alt_port += 4;
		}
		if (dma_port)
			dma_port += i * 8;
		a->port[i].irq = irq;
		a->port[i].io = base_port;
		a->port[i].alt_io = alt_port;
		a->port[i].dma_io = dma_port;
	}
	return 1;
}

