#ifndef CODE_FIXUP_FLAGS
#define CODE_FIXUP_FLAGS
#endif

#ifndef APORT_DEVICES
#define APORT_DEVICES(p)		APORT_DEVICE_ARRAY_SIZE
#endif

#ifndef CODE_PROBE_LIMIT
#define CODE_PROBE_LIMIT(p)		0
#endif

#ifndef CODE_POST
#define CODE_POST			AD_POST
static int AD_POST(ATARQ *rq);
#endif

#ifndef CODE_QUEUE_DEPTH
#define CODE_QUEUE_DEPTH		1
#endif

#ifndef CODE_LOCK_WAIT
#define CODE_LOCK_WAIT(p)		\
		while (__unlikely((p)->current_rq != NULL)) KERNEL$SLEEP(1);
#endif

#ifndef CODE_INIT_XFER
#define CODE_INIT_XFER(p, dev)
#endif

#ifndef CODE_AFTER_INIT
#define CODE_AFTER_INIT(p, dev)
#endif

#ifndef CODE_DETACH_XFER
#define CODE_DETACH_XFER(p, dev)
#endif

#ifndef NO_ATAPI
#define ATAPI_PARAM		, int atapi
#define ATAPI_PASS_PARAM	, atapi
#else
#define ATAPI_PARAM
#define ATAPI_PASS_PARAM
#endif

static int ATA_ATTACH(ACTRL *a, ATA_ATTACH_PARAM *ap  ATAPI_PARAM);
static void ATA_DETACH(ACTRL *a, ATA_ATTACH_PARAM *ap  ATAPI_PARAM);
static void ATA_LOCK(APORT *p);
static void ATA_UNLOCK(APORT *p);

static int ACTRL_AUX_CMD(ATA_ATTACH_PARAM *ap, int cmd, ...);
static void ATA_DEQUEUE(APORT *p);
#ifndef NO_ATAPI
static void ATAPI_INIT(SCSI_ATTACH_PARAM *sa);
#endif

__COLD_ATTR__ static int ATA_DCALL(void *ptr, const char *dcall_type, int cmd, va_list params)
{
	ACTRL *a = ptr;
	int r;
#ifndef NO_ATAPI
	int atapi = !strcmp(dcall_type, "ATAPI");
#else
	int atapi = 0;
#endif
	int spl = KERNEL$SPL;
	if (__unlikely(SPLX_BELOW(SPL_X(SPL_ATA_SCSI), spl)))
		KERNEL$SUICIDE("ATA_DCALL AT SPL %08X", spl);
	RAISE_SPL(SPL_ATA_SCSI);
	a->dcall_users++;
	if (!strcmp(dcall_type, "ATA") || atapi) {
		switch (cmd) {
			case ATA_CMD_GET:
				r = ATA_ATTACH(a, va_arg(params, ATA_ATTACH_PARAM *)  ATAPI_PASS_PARAM);
				break;
			case ATA_CMD_FREE:
				ATA_DETACH(a, va_arg(params, ATA_ATTACH_PARAM *)  ATAPI_PASS_PARAM);
				r = 0;
				break;
			default:
				r = -ENOOP;
				break;
		}
	}
#ifndef NO_ATAPI
	else if (!strcmp(dcall_type, "SCSI")) {
		switch (cmd) {
			SCSI_ATTACH_PARAM *ap;
			case SCSI_CMD_GET:
				ap = va_arg(params, SCSI_ATTACH_PARAM *);
				r = ATA$PI_ATTACH(a, ATA_DCALL, ap, a->n_ports, APORT_DEVICE_ARRAY_SIZE);
				if (!r) ATAPI_INIT(ap);
				break;
			case SCSI_CMD_FREE:
				ap = va_arg(params, SCSI_ATTACH_PARAM *);
				ATA$PI_DETACH(a, ATA_DCALL, ap);
				r = 0;
				break;
			default:
				r = ATA$PI_SCSI_DCALL(cmd, params);
				break;
		}
	}
#endif
	else KERNEL$SUICIDE("ATA_DCALL: UNKNOWN DCALL TYPE: %s", dcall_type);
	a->dcall_users--;
	LOWER_SPLX(spl);
	return r;
}

__COLD_ATTR__ static int ATA_ATTACH(ACTRL *a, ATA_ATTACH_PARAM *ap  ATAPI_PARAM)
{
	APORT *p;
	int i, dev;
	int pio_mask = -1;
	int dma_mask = -1, dma_mode = -1;
	int port = -1, device = -1;
	const char *arg;
	int state;
#ifndef NO_ATAPI
	unsigned dev_flags = !atapi ? 0 : DEV_F_ATAPI;
#else
	unsigned dev_flags = 0;
#endif
	static const struct __param_table params[] = {
		"PORT", __PARAM_INT, 0, MAXINT,
		"DEVICE", __PARAM_INT, 0, APORT_DEVICE_ARRAY_SIZE,
		"MASKIRQ", __PARAM_BOOL, DEV_F_MASKIRQ, DEV_F_MASKIRQ,
		"NOMASKIRQ", __PARAM_BOOL, DEV_F_MASKIRQ, 0,
#if DEV_F_IO32 != 0
		"IO32", __PARAM_BOOL, DEV_F_IO32, DEV_F_IO32,
		"NOIO32", __PARAM_BOOL, DEV_F_IO32, 0,
#endif
		"PIO", __PARAM_INT, 0, 7,
		"SDMA", __PARAM_BOOL_X, ~0, IDE_XFER_SDMA_0,
		"SDMA", __PARAM_INT, 0, 3,
		"WDMA", __PARAM_BOOL_X, ~0, IDE_XFER_WDMA_0,
		"WDMA", __PARAM_INT, 0, 5,
		"UDMA", __PARAM_BOOL_X, ~0, IDE_XFER_UDMA_0,
		"UDMA", __PARAM_INT, 0, 7,
		NULL, 0, 0, 0,
	};
	void *vars[sizeof(params) / sizeof(*params)];
	int vp = 0;
	vars[vp++] = &port;
	vars[vp++] = &device;
	vars[vp++] = &dev_flags;
	vars[vp++] = &dev_flags;
#if DEV_F_IO32 != 0
	vars[vp++] = &dev_flags;
	vars[vp++] = &dev_flags;
#endif
	vars[vp++] = &pio_mask;
	vars[vp++] = &dma_mode;
	vars[vp++] = &dma_mask;
	vars[vp++] = &dma_mode;
	vars[vp++] = &dma_mask;
	vars[vp++] = &dma_mode;
	vars[vp++] = &dma_mask;
	vars[vp++] = NULL;
	if (vp != sizeof(params) / sizeof(*params))
		KERNEL$SUICIDE("ATA_ATTACH: ARRAY SIZE MISCOUNTED: %d != %d", vp, (int)(sizeof(params) / sizeof(*params)));
	if (ap->version != ATA_VERSION) {
		ap->msg = "INCORRECT VERSION";
		return -EINVAL;
	}
	arg = ap->param;
	state = 0;
	if (__parse_extd_param(&arg, &state, params, vars, NULL, NULL, NULL, NULL)) {
		ap->msg = "SYNTAX ERROR";
		return -EBADSYN;
	}
	if (pio_mask >= 0) dev_flags |= IDE_XFER_PIO_0 << pio_mask;
	if (dma_mask >= 0) dev_flags |= dma_mode << dma_mask;
	if (port >= a->n_ports) {
		ap->msg = "INVALID PORT";
		return -ERANGE;
	}
	if (port >= 0 && device >= 0 && a->port[port].device[device].attached) {
		ap->msg = "DRIVER ALREADY ATTACHED";
		return -EBUSY;
	}
	if (port >= 0 && a->port[port].aport_flags & APORT_DISABLED) {
		ap->msg = "PORT IS DISABLED";
		return -ENXIO;
	}
	CODE_FIXUP_FLAGS;
	for (i = 0; i < a->n_ports; i++) {
		if (port >= 0 && port != i) continue;
		if (a->port[i].aport_flags & APORT_DISABLED) continue;
		for (dev = 0; dev < 2; dev++) {
			u_jiffies_lo_t probe_timeout;
			if (device >= 0 && device != dev) continue;
			if (dev >= APORT_DEVICES(&a->port[i])) continue;
			if (a->port[i].device[dev].attached) continue;
			if (ap->port) {
				if (ap->port > &a->port[i]) continue;
				if (ap->port == &a->port[i] && ap->device >= dev) continue;
			}
			/* attach it */
			p = &a->port[i];
			p->device[dev].attached = ap;
			ap->port = p;
			ap->device = dev;

		/* Attached */

			probe_timeout = ap->probe_timeout;
			p->device[dev].dev_flags = dev_flags;
			if (CODE_PROBE_LIMIT(p) && probe_timeout > CODE_PROBE_LIMIT(p)) probe_timeout = CODE_PROBE_LIMIT(p);
			CODE_DISK_NAME(*ap->dev_name, sizeof *ap->dev_name, ap->dev_prefix, a, i, dev);
			ap->post = CODE_POST;
			ap->aux_cmd = ACTRL_AUX_CMD;
			ap->queue_depth = CODE_QUEUE_DEPTH;

#include "FN_INI.I"

			ap->probe_timeout = probe_timeout;
			return 0;
		}
	}
	return -ENODEV;
}

__COLD_ATTR__ static void ATA_DETACH(ACTRL *a, ATA_ATTACH_PARAM *ap  ATAPI_PARAM)
{
	APORT *p = ap->port;
#if __DEBUG >= 2
	KERNEL$SLEEP(1);	/* test block */
#endif
	if (p < a->port || p >= a->port + a->n_ports)
		KERNEL$SUICIDE("ATA_DETACH: %s: DETACHING INVALID STRUCTURE, PORT %p, OUR PORT %p, N_PORTS %d", a->dev_name, p, a->port, a->n_ports);
	if (ap->device >= APORT_DEVICES(p))
		KERNEL$SUICIDE("ATA_DETACH: %s: INVALID DEVICE %d", a->dev_name, ap->device);
	if (p->device[ap->device].attached != ap)
		KERNEL$SUICIDE("ATA_DETACH: %s: STRUCTURE %p NOT ATTACHED, CURRENTLY ATTACHED %p", a->dev_name, ap, p->device[ap->device].attached);
#ifndef NO_ATAPI
	if (atapi != !!(p->device[ap->device].dev_flags & DEV_F_ATAPI))
		KERNEL$SUICIDE("ATA_DETACH: %s: ATAPI FLAG (%d) DOES NOT MATCH, DEV_FLAGS %X", a->dev_name, atapi, p->device[ap->device].dev_flags);
#endif
	ATA_LOCK(p);
	CODE_DETACH_XFER(p, ap->device);
	ATA_UNLOCK(p);
	ap->port->device[ap->device].attached = NULL;
}

__COLD_ATTR__ static void ATA_LOCK(APORT *p)
{
	if (__unlikely(KERNEL$SPL != SPL_X(SPL_ATA_SCSI)))
		KERNEL$SUICIDE("ATA_LOCK AT SPL %08X", KERNEL$SPL);
	while (__unlikely(p->aport_flags & APORT_LOCK)) KERNEL$SLEEP(1);
	p->aport_flags |= APORT_LOCK;
	CODE_LOCK_WAIT(p);
}

__COLD_ATTR__ static void ATA_UNLOCK(APORT *p)
{
	if (__unlikely(KERNEL$SPL != SPL_X(SPL_ATA_SCSI)))
		KERNEL$SUICIDE("ATA_UNLOCK AT SPL %08X", KERNEL$SPL);
	KERNEL$SLEEP(1);	/* Ignore a possible interrupt */
	p->aport_flags &= ~APORT_LOCK;
	ATA_DEQUEUE(p);
}

#undef ATAPI_PARAM
#undef ATAPI_PASS_PARAM
