#ifndef CODE_TEST_LOCKED
#define CODE_TEST_LOCKED						\
	if (__unlikely(p->aport_flags & APORT_LOCK)) return -EAGAIN;	\
	if (__unlikely(p->current_rq != NULL)) return -EAGAIN;
#endif

#ifndef CODE_MANGLE_REQUEST
#define CODE_MANGLE_REQUEST
#endif

#ifndef CODE_ERROR_CONDITION
#define CODE_ERROR_CONDITION
#endif

#ifndef CODE_PREPARE_FOR_IRQ
#define CODE_PREPARE_FOR_IRQ(p)
#endif

#ifndef CODE_SETUP_XFER
#define CODE_SETUP_XFER(p, rq)
#endif

#ifndef CODE_END_REQUEST_EXTRA
#define CODE_END_REQUEST_EXTRA
#endif

static void ATA_END_REQUEST(APORT *p, int status);
static void AD_UNMAP_REQUEST(ATARQ *rq);

static void ATA_TIMEOUT(TIMER *t);

#define ATA_DI(p, d)							\
do {									\
	if (__unlikely((p)->device[d].dev_flags & DEV_F_MASKIRQ)) KERNEL$DI(); \
} while (0)

#define ATA_EI(p, d)							\
do {									\
	if (__unlikely((p)->device[d].dev_flags & DEV_F_MASKIRQ)) KERNEL$EI(); \
} while (0)

static void ATA_PIO_POLL(TIMER *t);

__COLD_ATTR__ static char *RQ_2_DEV_NAME(ATARQ *rq)
{
	return *rq->port->device[rq->device].attached->dev_name;
}

__COLD_ATTR__ static int DONT_RETRY(int dmastatus, int status, int error)
{
	if (status & ATA_STATUS_BSY)
		return 1;
	if (status & ATA_STATUS_ERROR) {
		if (error & (ATA_ERROR_NM | ATA_ERROR_IDNF | ATA_ERROR_UNC))
			return 1;
		if (error & ATA_ERROR_ICRC)
			return 0;
		if (error & ATA_ERROR_ABORT)
			return 1;
	}
	return 0;
}

__COLD_ATTR__ static void AD_RETRY(ATARQ *rq)
{
	KERNEL$DEL_TIMER(&rq->port->timeout);
	rq->atarq_flags |= ATARQ_RETRIED;
	rq->port->device[rq->device].attached->post(rq);
}

__COLD_ATTR__ static void AD_ERROR(APORT *p, int dmastatus, int status, int timeout)
{
	int code;
	char *description;
	char dmastr[16];
	ATARQ *rq = p->current_rq;
	__u8 error = ATA_IN_ERROR(p);
	__u8 drdy = p->device[rq->device].dev_flags & DEV_F_ATAPI ? 0 : ATA_STATUS_DRDY;
	if (DONT_RETRY(dmastatus, status, error)) rq->retries = 0;	/* do not try again */
	code = -EIO;
	if (timeout) {
		description = "TIMEOUT";
		code = -ETIMEDOUT;
	} else if (status & ATA_STATUS_BSY) {
		description = "BUSY";
	} else if (status & ATA_STATUS_DF) {
		if (rq->atarq_flags & ATARQ_ERROR_ALLOW_ABORT) {
			description = NULL;
			code = -EOPNOTSUPP;
		} else {
			description = "DEVICE FAULT";
		}
	} else if (status & ATA_STATUS_ERROR && error & ATA_ERROR_UNC) {
		description = "UNCORRECTABLE ERROR";
	} else if (
#ifdef DMASTATUS_ERROR
		(dmastatus >= 0 && dmastatus & DMASTATUS_ERROR) ||
#endif
		(status & ATA_STATUS_ERROR && error & ATA_ERROR_ICRC)) {
		description = "DMA CRC ERROR";
	} else if (status & ATA_STATUS_ERROR && error & (ATA_ERROR_NM | ATA_ERROR_MC | ATA_ERROR_MCR)) {
		if (rq->atarq_flags & ATARQ_ERROR_ALLOW_ABORT) {
			description = NULL;
			code = -EOPNOTSUPP;
		} else {
			description = "MEDIA ERROR";
			code = -ENOMEDIUM;
		}
	} else if (status & ATA_STATUS_ERROR && error & ATA_ERROR_ABORT) {
		if (rq->atarq_flags & ATARQ_ERROR_ALLOW_ABORT) {
			description = NULL;
			code = -EOPNOTSUPP;
		} else {
			description = "ABORT";
		}
	} else if ((status & (ATA_STATUS_DRQ | drdy)) != drdy) {
		description = "PROTOCOL VIOLATION";
	} else {
		if (rq->atarq_flags & ATARQ_ERROR_ALLOW_ABORT) {
			description = NULL;
			code = -EOPNOTSUPP;
		} else {
			description = "ERROR";
		}
	}
	if (description) {
		if (dmastatus >= 0) {
			_snprintf(dmastr, sizeof dmastr, "DMA STATUS %02X, ", dmastatus);
		} else {
			*dmastr = 0;
		}
		CODE_ERROR_CONDITION {
			KERNEL$SYSLOG(__SYSLOG_HW_ERROR, RQ_2_DEV_NAME(rq), "%s ON COMMAND %s, %sDRIVE STATUS %02X, ERROR %02X - %s", description, ATA$COMMAND_NAME(rq->fis.command, rq->fis.feature0), dmastr, status, error, rq->retries ? "RETRYING" : "ABORTING");
		}
	}
	if (rq->retries--) {
		AD_RETRY(rq);
	} else {
		AD_UNMAP_REQUEST(rq);
		ATA_END_REQUEST(p, code);
	}
}

static int ATA_NONDMA_IRQ(APORT *p, __u8 status)
{
	int n;
	ATARQ *rq = p->current_rq;
	if (__likely((rq->atarq_flags & ATARQ_PROTOCOL) == ATA_PROTOCOL_NODATA)) {
		__u8 drdy;
		end_test_status:
		drdy = p->device[rq->device].dev_flags & DEV_F_ATAPI ? 0 : ATA_STATUS_DRDY;
		if (__unlikely((status & (ATA_STATUS_ERROR | ATA_STATUS_DRQ | ATA_STATUS_DF | drdy)) != drdy)) {
			ad_error:
			AD_ERROR(p, -1, status, 0);
			return 0;
		}
		AD_UNMAP_REQUEST(rq);
		ATA_END_REQUEST(p, 0);
		return 0;
	}
#if __DEBUG >= 1
	if (__likely((rq->atarq_flags & ATARQ_PROTOCOL) != ATA_PROTOCOL_PIO))
		KERNEL$SUICIDE("ATA_NONDMA_IRQ: UNKNOWN PROTOCOL, FLAGS %X", rq->atarq_flags);
#endif
	if (__unlikely(!p->pio_n_sect)) {
		if (__unlikely(status & ATA_STATUS_DRQ)) goto poll_me;
		goto end_test_status;
	}
	if (!(status & ATA_STATUS_DRQ)) {
		if (__unlikely(status & (ATA_STATUS_ERROR | ATA_STATUS_DF))) goto ad_error;
		/* Warning: hack: Transcend IDE aborts requests to non-existent
		   slave ATAPI with 0 in status */
		if (!status && rq->fis.command == ATA_CMD_IDENTIFY_PACKET_DEVICE)
			goto ad_error;
		/* This happens with IBM Deskstar */
		goto poll_me;
	}
	n = rq->multicount;
	if (__unlikely(!n)) KERNEL$SUICIDE("ATA_NONDMA_IRQ: ZERO MULTICOUNT");
	if (__unlikely(n >= p->pio_n_sect)) {
		n = p->pio_n_sect;
		if (__unlikely(rq->atarq_flags & ATARQ_TO_DEVICE))
			goto prepare_irq;
	} else {
		prepare_irq:
		CODE_PREPARE_FOR_IRQ(p);
	}
	ATA_DI(p, rq->device);
	do {
		void *data = ATA$MAP_PIO_SECTOR(p->sglist, p->pio_sg_pos);
		ATA$SET_NEXT_PIO_SECTOR(p->sglist, &p->pio_sg_pos);
		if (__likely(!(rq->atarq_flags & ATARQ_TO_DEVICE))) {
			ATA_INS(p, p->device[rq->device].dev_flags & DEV_F_IO32, data, 256);
		} else {
			ATA_OUTS(p, p->device[rq->device].dev_flags & DEV_F_IO32, data, 256);
		}
		ATA$UNMAP_PIO_SECTOR(p->sglist, data);
		p->pio_n_sect--;
	} while (--n > 0);
	ATA_EI(p, rq->device);
	if (__unlikely(status & (ATA_STATUS_ERROR | ATA_STATUS_DF))) goto ad_error;
	if (__unlikely(!p->pio_n_sect) && __likely(!(rq->atarq_flags & ATARQ_TO_DEVICE))) {
		status = ATA_IN_STATUS(p);
		if (__unlikely(status & (ATA_STATUS_BSY | ATA_STATUS_DRQ))) {
			goto poll_me;
		}
		goto end_test_status;
	}
	poll_me:
	return 1;
}

static void ATA_PIO_POLL(TIMER *t)
{
	__u8 status;
	APORT *p = GET_STRUCT(t, APORT, timeout);
	LOWER_SPL(SPL_ATA_SCSI);
	status = ATA_IN_STATUS(p);
	if (__likely(!(status & ATA_STATUS_BSY))) {
		SET_TIMER_NEVER(&p->timeout);
		KERNEL$UDELAY(10);	/* Linux code has it because of some buggy disks */
		status = ATA_IN_STATUS(p);
		if (ATA_NONDMA_IRQ(p, status)) {
			KERNEL$DEL_TIMER(&p->timeout);
			goto not_yet;
		}
		return;
	}
	not_yet:
	if (__unlikely(KERNEL$GET_JIFFIES_LO() - p->pio_timeout > p->current_rq->timeout)) {
		ATA_TIMEOUT(&p->timeout);
		return;
	}
	KERNEL$SET_TIMER(0, &p->timeout);
}

static int AD_POST(ATARQ *rq)
{
	APORT *p = rq->port;
	int r;
	if (__unlikely(rq->atarq_flags & ATARQ_RETRIED)) {
#if __DEBUG >= 1
		if (__unlikely(rq != p->current_rq))
			KERNEL$SUICIDE("AD_POST: RETRYING NON-CURRENT REQUEST %p, CURRENT %p", rq, p->current_rq);
#endif
		goto retrying;
	}
	CODE_TEST_LOCKED;	/* may return -EAGAIN */
	CODE_MANGLE_REQUEST;
#ifndef POST_ONLY_PIO
	if (__likely(rq->atarq_flags & ATA_PROTOCOL_DMA)) {
		r = ATA$MAP_DMA(p->sglist, &rq->desc, rq->len, PF_WRITE + ((rq->atarq_flags / ATARQ_TO_DEVICE) & 1), 0);
		goto test_error_set_size;
	} else
#endif
	if (__unlikely((rq->atarq_flags & ATARQ_PROTOCOL) != ATA_PROTOCOL_NODATA)) {
		r = ATA$MAP_PIO(p->sglist, &rq->desc, rq->len, PF_WRITE + ((rq->atarq_flags / ATARQ_TO_DEVICE) & 1), 0);
		p->pio_n_sect = r >> BIO_SECTOR_SIZE_BITS;
		p->pio_sg_pos = 0;
#ifndef POST_ONLY_PIO
		test_error_set_size:
#endif
		if (__unlikely(r < 0)) return r;
		if (__likely(rq->atarq_flags & ATARQ_SET_SIZE)) {
			rq->len = r;
			rq->fis.nsect0 = r >> BIO_SECTOR_SIZE_BITS;
			rq->fis.nsect8 = r >> (BIO_SECTOR_SIZE_BITS + 8);
		} else if (__unlikely(r != rq->len)) {
			AD_UNMAP_REQUEST(rq);
			return -EVSPACEFAULT;
		}
	}
	p->current_rq = rq;

	retrying:
	CODE_SETUP_XFER(p, rq);
#ifndef POST_ONLY_PIO
	if (__likely(rq->atarq_flags & ATA_PROTOCOL_DMA)) {
		CODE_SETUP_DMA(p, rq);
	}
#endif
#ifdef CODE_LOAD_TASKFILE
	CODE_LOAD_TASKFILE;
#else
	ATA_OUT_DRIVE(p, rq->fis.device | (rq->device * ATA_DEVICE_DRIVE));
	if (__unlikely(rq->atarq_flags & ATARQ_VALID_FEATURE)) {
		if (rq->atarq_flags & ATARQ_VALID_48BIT) {
			ATA_OUT_FEATURES(p, rq->fis.feature8);
		}
		ATA_OUT_FEATURES(p, rq->fis.feature0);
	}
	if (rq->atarq_flags & ATARQ_VALID_48BIT) {
		ATA_OUT_COUNT(p, rq->fis.nsect8);
		ATA_OUT_LBA_L(p, rq->fis.lba24);
		ATA_OUT_LBA_M(p, rq->fis.lba32);
		ATA_OUT_LBA_H(p, rq->fis.lba40);
	}
	ATA_OUT_COUNT(p, rq->fis.nsect0);
	ATA_OUT_LBA_L(p, rq->fis.lba0);
	ATA_OUT_LBA_M(p, rq->fis.lba8);
	ATA_OUT_LBA_H(p, rq->fis.lba16);
	CODE_PREPARE_FOR_IRQ(p);
	ATA_OUT_CMD(p, rq->fis.command);
#endif
#ifndef POST_ONLY_PIO
	if (__likely(rq->atarq_flags & ATA_PROTOCOL_DMA)) {
		CODE_START_DMA(p, rq);
		p->timeout.fn = ATA_TIMEOUT;
		KERNEL$SET_TIMER(rq->timeout, &p->timeout);
		return 0;
	} else
#endif
	{
/* PIO is both interrupt driven and polled, there are reportedly some
   controllers that do not assert interrupt on PIO transfers.
   Also, I found one CD-ROM drive that magically disables PIO interrupt
   if it's reset at unexpected time.
*/
		p->pio_timeout = KERNEL$GET_JIFFIES_LO();
		p->timeout.fn = ATA_PIO_POLL;
		KERNEL$SET_TIMER(0, &p->timeout);
		return 0;
	}
}

#if APORT_DEVICE_ARRAY_SIZE == 2
static void ATA_SELECT_DEVICE(APORT *p, ATA_ATTACH_PARAM *me, ATA_ATTACH_PARAM *other, BIORQ *b1);
#endif
static void ATA_DEQUEUE(APORT *p);

static void ATA_END_REQUEST(APORT *p, int status)
{
	unsigned dev;
	ATARQ *rq;
#if APORT_DEVICE_ARRAY_SIZE == 2
	ATA_ATTACH_PARAM *me, *other;
	BIORQ *b1;
#endif
	rq = p->current_rq;
	rq->status = status;
	KERNEL$DEL_TIMER(&p->timeout);
	p->current_rq = NULL;
	CODE_END_REQUEST_EXTRA;
	dev = rq->device;
	rq->done(rq);
#if APORT_DEVICE_ARRAY_SIZE == 1
	ATA_DEQUEUE(p);
#elif APORT_DEVICE_ARRAY_SIZE == 2
	me = p->device[dev].attached;
	if (__likely(!(other = p->device[dev ^ 1].attached)) || __likely(!(b1 = other->probe_queue(other)))) {
		while (__unlikely(me->dequeue(me) == BIO_DEQUEUE_WANT_MORE)) ;
	} else {
		ATA_SELECT_DEVICE(me->port, me, other, b1);
	}
#else
	error
#endif
}

#if APORT_DEVICE_ARRAY_SIZE == 2
static void ATA_SELECT_DEVICE(APORT *p, ATA_ATTACH_PARAM *me, ATA_ATTACH_PARAM *other, BIORQ *b1)
{
	BIORQ *b0;
	long c;
	b0 = me->probe_queue(me);
	compare_again:
	if (!b0) {
		deq_other:
		me = other;
		goto deq_me;
	}
	if (!b1) {
		deq_me:
		while (__unlikely(me->dequeue(me) == BIO_DEQUEUE_WANT_MORE)) ;
		return;
	}
	c = BIOQUE$COMPARE_REQUESTS(b0, me->biosched, b1, other->biosched);
	if (c < 0) {
		if (__unlikely(me->dequeue(me) != BIO_DEQUEUE_WANT_MORE)) goto deq_other;
		b0 = me->probe_queue(me);
		goto compare_again;
	} else {
		if (__unlikely(other->dequeue(other) != BIO_DEQUEUE_WANT_MORE)) goto deq_me;
		b1 = other->probe_queue(other);
		goto compare_again;
	}
}
#endif

static void ATA_DEQUEUE(APORT *p)
{
#if APORT_DEVICE_ARRAY_SIZE == 1
	ATA_ATTACH_PARAM *me = p->device[0].attached;
	if (__likely(me != NULL))
		while (__unlikely(me->dequeue(me) == BIO_DEQUEUE_WANT_MORE)) ;
#elif APORT_DEVICE_ARRAY_SIZE == 2
	ATA_ATTACH_PARAM *a0 = p->device[0].attached;
	ATA_ATTACH_PARAM *a1 = p->device[1].attached;
	if (__unlikely(!a0)) {
		if (__unlikely(!a1)) return;
		while (__unlikely(a1->dequeue(a1) == BIO_DEQUEUE_WANT_MORE)) ;
		return;
	} else if (!a1) {
		while (__unlikely(a0->dequeue(a0) == BIO_DEQUEUE_WANT_MORE)) ;
		return;
	}
	ATA_SELECT_DEVICE(p, a0, a1, a1->probe_queue(a1));
#else
	error
#endif
}

static void AD_UNMAP_REQUEST(ATARQ *rq)
{
	if (__likely(rq->atarq_flags & ATA_PROTOCOL_DMA)) {
		ATA$UNMAP_DMA(rq->port->sglist);
	} else if (__likely((rq->atarq_flags & ATARQ_PROTOCOL) != ATA_PROTOCOL_NODATA)) {
		ATA$UNMAP_PIO(rq->port->sglist);
	}
}

#ifndef NO_AD_POLL_SLOW_DISK

static __u8 AD_POLL_SLOW_DISK(APORT *p, __u8 dmastatus, __u8 status)
{
	__u8 newstatus;
	int i;
	for (i = 0; i < 10; i++) {
		newstatus = ATA_IN_STATUS(p);
		if (!(newstatus & (ATA_STATUS_BSY | ATA_STATUS_DRQ))) {
/* I'm not sure if we want to log this, if it annoys someone, it will be removed */
			KERNEL$SYSLOG(__SYSLOG_HW_NONFATAL_BUG, RQ_2_DEV_NAME(p->current_rq), "DEVICE TRIGGERED INTERRUPT BEFORE DEASSERTING BSY. COMMAND %s, DMA STATUS %02X, ORIGINAL DRIVE STATUS %02X, NEW DRIVE STATUS %02X", ATA$COMMAND_NAME(p->current_rq->fis.command, p->current_rq->fis.feature0), dmastatus, status, newstatus);
			return newstatus;
		}
		KERNEL$UDELAY(10);
	}
	KERNEL$SYSLOG(__SYSLOG_HW_NONFATAL_BUG, RQ_2_DEV_NAME(p->current_rq), "DEVICE TRIGGERED INTERRUPT BUT DIDN'T DEASSERT BSY OR DRQ. COMMAND %s, DMA STATUS %02X, ORIGINAL DRIVE STATUS %02X, NEW DRIVE STATUS %02X", ATA$COMMAND_NAME(p->current_rq->fis.command, p->current_rq->fis.feature0), dmastatus, status, newstatus);
	return newstatus;
}

#endif
