#define RESET_FF_TIMEOUT	(JIFFIES_PER_SECOND * 1)
#define POLL_TIME		(JIFFIES_PER_SECOND / 10)

{
	__u8 status;
	int slept, reset, reset_verbose;

/* Drain pending requests */

	ATA_LOCK(p);

	CODE_INIT_XFER(p, dev);

/* Test for BUSY */

	reset = 0;
	after_reset:

#if APORT_DEVICE_ARRAY_SIZE > 1
/* Linux source says that non-ready slave can break master detection */
	if (CODE_WAIT_FOR_OTHER_DEVICE(p) && !p->device[dev ^ 1].attached) {
		slept = 0;
		after_other_sleep:
		ATA_OUT_DRIVE(p, (dev ^ 1) * ATA_DEVICE_DRIVE);
		KERNEL$UDELAY(10);
		status = ATA_IN_STATUS(p);
		if (status & ATA_STATUS_BSY && status != 0xff) {
			if (slept >= probe_timeout / POLL_TIME) goto other_not_ready;
			KERNEL$SLEEP(POLL_TIME);
			slept++;
			goto after_other_sleep;
		}
		other_not_ready:;
	}
#endif

	slept = 0;
	after_sleep:
	ATA_OUT_DRIVE(p, dev * ATA_DEVICE_DRIVE);
	KERNEL$UDELAY(10);
	status = ATA_IN_STATUS(p);
	if (status & ATA_STATUS_BSY) {
		if (slept >= probe_timeout / POLL_TIME) {
			reset_verbose = 0;
			goto try_reset;
		}
		if (status == 0xff && !reset && slept >= RESET_FF_TIMEOUT / POLL_TIME) goto detach_cont;
		KERNEL$SLEEP(POLL_TIME);
		slept++;
		goto after_sleep;
	}
	if (reset == 1) {
		int error = ATA_IN_ERROR(p);
		if (error != 1 && error != 0) {
			KERNEL$SYSLOG(__SYSLOG_HW_ERROR, *ap->dev_name, "RESET FAILED, STATUS %02X, ERROR %02X", status, error);
			goto detach_cont;
		}
	}
	if (status & ATA_STATUS_DF) {
		detach_cont:
		ATA_UNLOCK(p);
		ATA_DETACH(a, ap  ATAPI_PASS_PARAM);
		continue;
	}
	if (status & ATA_STATUS_DRQ) {
		char *str;
		reset_verbose = 1;
		try_reset:
		if (reset) goto detach_cont;
#ifndef NO_ATAPI
		if (atapi) {
			reset = 3;
			ATA_OUT_CMD(p, ATA_CMD_DEVICE_RESET);
			KERNEL$UDELAY(10);
			str = "RESETTING DEVICE";
		} else
#endif
		if (
#if APORT_DEVICE_ARRAY_SIZE > 1
			   !p->device[dev ^ 1].attached &&
#endif
			   !CODE_INIT_CANT_RESET(p)) {
			reset = 1;
			ATA_OUT_CTRL(p, ATA_CTRL_ONE | ATA_CTRL_SRST);
			KERNEL$UDELAY(10);
			ATA_OUT_CTRL(p, ATA_CTRL_ONE);
			KERNEL$UDELAY(10);
			str = "RESETTING BUS";
		} else {
			reset = 2;
			ATA_OUT_FEATURES(p, ATA_FEATURE_NOP_NOP);
			KERNEL$UDELAY(10);
			ATA_OUT_CMD(p, ATA_CMD_NOP);
			KERNEL$UDELAY(10);
			str = "SENDING NOP";
		}
		if (reset_verbose)
			KERNEL$SYSLOG(__SYSLOG_HW_ERROR, *ap->dev_name, "DRIVE LEFT IN INCONSISTENT STATE (STATUS %02X), %s", status, str);
		goto after_reset;
	}
	if (
#ifndef NO_ATAPI
	    !atapi &&
#endif
	    !(status & ATA_STATUS_DRDY)) {
		goto detach_cont;
	}
	if (!status) {
		/* On Promise PDC, non-present channel reads as all zeros.
		 * Some valid CD-ROMs are initialized with zero status.
		 * To distinguish these two cases, do a test write. */
		ATA_OUT_LBA_M(p, 0xaa);
		if (ATA_IN_LBA_M(p) != 0xaa) {
			goto detach_cont;
		}
	}
	CODE_AFTER_INIT(p, dev);
	ATA_UNLOCK(p);

/* Now we are surely attached */

}

