#ifndef __ATA_HOST_K2REG_H
#define __ATA_HOST_K2REG_H

#define PORT_SPACE		0x100
#define EXTENDED_SPACE		0x2000

#define PORT_DATA		0x0000
#define PORT_FEATURES		0x0004
#define PORT_ERROR		0x0004
#define PORT_COUNT		0x0008
#define PORT_LBA_L		0x000c
#define PORT_LBA_M		0x0010
#define PORT_LBA_H		0x0014
#define PORT_DRIVE		0x0018
#define PORT_CMD		0x001c
#define PORT_STATUS		0x001c
#define PORT_CTRL		0x0020
#define PORT_ALTSTATUS		0x0020
#define PORT_DMA_CMD		0x0030
#define PORT_DMA_STATUS		0x0032
#define PORT_DMA_DTP		0x0034
#define PORT_SCR_STATUS		0x0040
#define PORT_SCR_ERROR		0x0044
#define PORT_SCR_CONTROL	0x0048
#define PORT_SICR1		0x0080
#define PORT_SICR2		0x0084
#define PORT_SIM		0x0088

#define PORT_QAL		0x00a0
#define PORT_QAU		0x00a4
#define PORT_QPI		0x00a8
#define PORT_QCI		0x00ac
#define PORT_QCR		0x00b0
#define  PORT_QCR_QDMA_ENABLE		0x01
#define  PORT_QCR_QDMA_PAUSE		0x02
#define  PORT_QCR_QDMA_ABORT		0x04
#define  PORT_QCR_QDMA_RESET		0x08
#define PORT_QDR		0x00b4
#define PORT_QSR		0x00b8
#define  PORT_QSR_CMD_DONE		0x00000001
#define  PORT_QSR_PAUSE_ACK		0x00000002
#define  PORT_QSR_ABORT_ACK		0x00000004
#define  PORT_QSR_RESET_ACK		0x00000008
#define  PORT_QSR_DEV_CHANGE		0x00000010
#define  PORT_QSR_CMD_ERROR		0x00000020
#define  PORT_QSR_BUS_MASTER_ERROR	0x00010000
#define  PORT_QSR_ERROR			0x00020000
#define  PORT_QSR_OVERFLOW		0x00040000
#define  PORT_QSR_UNDERFLOW		0x00080000
#define  PORT_QSR_DATA_CRC_ERROR	0x00100000
#define  PORT_QSR_PCI_MASTER_ABORT	0x00200000
#define  PORT_QSR_ATAPI_UNDERRUN	0x00400000
#define PORT_QMR		0x00bc
#define  PORT_QMR_CMD_DONE		0x01
#define  PORT_QMR_PAUSE_ACK		0x02
#define  PORT_QMR_ABORT_ACK		0x04
#define  PORT_QMR_RESET_ACK		0x08
#define  PORT_QMR_DEV_CHANGE		0x10
#define  PORT_QMR_CMD_ERROR		0x20

#define PORT_SATADBGREG		0x00f0

#define K2_MDIOCTRLREG		0x008c
#define K2_GLB_CTL		0x1000
#define K2_GLB_STS		0x1004
#define K2_TESTCTRLREG		0x10f0

typedef struct {
	__u8 desc_type;
#define K2_CMD_DESC_TYPE_PIO_DATA	0x00
#define K2_CMD_DESC_TYPE_D		0x01
#define K2_CMD_DESC_TYPE_PIO_NO_DATA	0x02
	__u8 ctrl_flags;
#define K2_CMD_CTRL_FLAG_EIN		0x01
#define K2_CMD_CTRL_FLAG_READ_DIR	0x02
#define K2_CMD_CTRL_FLAG_IGNR		0x08
#define K2_CMD_CTRL_FLAG_SKIP		0x10
#define K2_CMD_CTRL_FLAG_ATAPI		0x40
#define K2_CMD_CTRL_FLAG_PIO		0x80
	__u8 port_mul;
	__u8 rsvd_1;
	__u16 host_mem_data_buf_addr;
	__u16 tag;
	__u32 prd_lo;
#define K2_CMD_PRD_LO_DIRECT		0x00000001
	__u16 prd_hi;
	__u16 prd_count;
	__u8 command;
	__u8 device;
	__u8 feature0;
	__u8 feature8;
	__u8 lba0;
	__u8 lba8;
	__u8 lba16;
	__u8 lba24;
	__u8 lba32;
	__u8 lba40;
	__u8 nsect0;
	__u8 nsect8;
	__u32 rsvd_2;
} K2_CMD;

/*
 * Register status after data-less PIO command.
 * If you use it, investigate the content of other registers.
 */
typedef struct {
	__u8 status;
	__u8 other[0x1f];
} K2_STATUS;

#endif
