#ifndef __ATA_HOST_PROMREG_H
#define __ATA_HOST_PROMREG_H

#define PDC_REGSPACE		0x800

#define PDC_TBG_MODE		0x41c
#define  PDC_TBG_MODE_N			0x000000ff
#define  PDC_TBG_MODE_M			0x00003f00
#define  PDC_TBG_MODE_MN_ENABLE		0x00004000
#define  PDC_TBG_MODE_HIKVCOA		0x00008000
#define  PDC_TBG_MODE_FREQ		0x00030000
#define   PDC_TBG_MODE_FREQ_100			0x00000000
#define   PDC_TBG_MODE_FREQ_133			0x00010000
#define   PDC_TBG_MODE_FREQ_150			0x00020000
#define  PDC_TBG_MODE_VCO_HALF		0x00040000
#define PDC_SLEW_CTL		0x470
#define  PDC_SLEW_CTL_ATAZN2		0x00000007
#define  PDC_SLEW_CTL_ATAZP2		0x00000038
#define  PDC_SLEW_CTL_ATAZN1		0x000001c0
#define  PDC_SLEW_CTL_ATAZP1		0x00000e00
#define  PDC_SLEW_CTL_PCIZN		0x0000f000
#define  PDC_SLEW_CTL_PCIZP		0x000f0000

#define PDC_SEQ_COUNTER		0x000
#define  PDC_SEQ_COUNTER_CNT		0x0000001f
#define  PDC_SEQ_COUNTER_INT_MASK	0x00000020
#define  PDC5_SEQ_COUNTER_FPDMA		0x00000040
#define  PDC_SEQ_COUNTER_A0_ERROR	0x00010000
#define  PDC_SEQ_COUNTER_A1_ERROR	0x00020000
#define  PDC_SEQ_COUNTER_A2_ERROR	0x00040000
#define  PDC_SEQ_COUNTER_A3_ERROR	0x00080000
#define  PDC_SEQ_COUNTER_X_ERROR	0x00100000
#define PDC_INT_SEQMASK		0x40
#define PDC_FLASH_CTL		0x44
#define  PDC5_FLASH_CTL_BMR_BURST_SHR	0x00001f00
#define  PDC5_FLASH_CTL_BMR_BURST_ENA	0x00002000
#define  PDC_FLASH_CTL_FIFO_SHD		0x00010000
#define  PDC_FLASH_CTL_FPAGE		0x00fc0000
#define  PDC_FLASH_CTL_TFAH		0x03000000
#define  PDC_FLASH_CTL_TFPW		0x3c000000
#define  PDC_FLASH_CTL_TFAS		0xc0000000
#define PDC_PCI_CTL_STAT	0x48
#define  PDC_PCI_CTL_STAT_BIOS_SIZE	0x0000000c
#define  PDC_PCI_CTL_STAT_INIT_STATE	0x00000010
#define  PDC_PCI_CTL_STAT_FLASH_ENABLE	0x00000020
#define  PDC_PCI_CTL_STAT_SUBSYS_ID	0x00000040
#define  PDC5_PCI_CTL_STAT_D1_D3_CTL_EN	0x00000800
#define  PDC_PCI_CTL_STAT_RESET_1	0x00001000
#define  PDC_PCI_CTL_STAT_RESET_2	0x00002000
#define  PDC_PCI_CTL_STAT_RESET_3	0x00004000
#define  PDC_PCI_CTL_STAT_RESET_4	0x00008000
#define  PDC5_PCI_CTL_STAT_FBDIV	0x0c000000
#define  PDC5_PCI_CTL_STAT_REFDIV	0x30000000
#define  PDC5_PCI_CTL_STAT_REFCLK	0xc0000000
#define PDC_SER_CTL		0x50
#define  PDC_SER_CTL_CYC		0x00000003
#define  PDC_SER_CTL_RST		0x00000100
#define  PDC_SER_CTL_FINISH		0x00000200
#define  PDC_SER_CTL_ERR		0x00000400
#define  PDC_SER_CTL_MASK_FINISH	0x00000800
#define  PDC_SER_CTL_MASK_ERR		0x00001000
#define  PDC_SER_CTL_RCNT		0x00070000
#define  PDC_SER_CTL_WCNT		0x00700000
#define PDC_SER_TDATA		0x54
#define PDC_SER_RDATA		0x58
#define PDC_EXT_DATA0		0x5c
#define  PDC_EXT_DATA0_REG		0x7fffffff
#define  PDC_EXT_DATA0_INT_FORCE	0x80000000
#define PDC_EXT_DATA1		0x60
#define PDC_EXT_DATA2		0x64
#define PDC_EXT_MSI_CTL		0x68
#define  PDC_EXT_MSI_CTL_CLEAR_HOLD	0x00000001
#define  PDC_EXT_MSI_CTL_ENABLE_HOLD	0x00000002
#define PDC_SATA_PLUG_CSR	0x6c
#define  PDC_SATA_PLUG_CSR_UNPLUG	0x0000000f
#define  PDC_SATA_PLUG_CSR_PLUG		0x000000f0
#define  PDC_SATA_PLUG_CSR_CONNECT_WELL	0x00000f00
#define  PDC_SATA_PLUG_CSR_MASK_PLUG	0x000f0000
#define  PDC_SATA_PLUG_CSR_MASK_UNPLUG	0x00f00000
#define  PDC5_SATA_PLUG_CSR_SHUTDN_PHY	0x0f000000
#define PDC5_EXT_DATA0		0x50
#define PDC5_EXT_DATA1		0x54
#define PDC5_EXT_DATA2		0x58
#define PDC5_EXT_MSI_CTL	0x5c
#define PDC5_SATA_PLUG_CSR	0x60
#define PDC5_SER_CTL		0x64
#define  PDC5_SER_CTL_SB_MS_DONE	0x00000001
#define  PDC5_SER_CTL_SB_CMD_ERR	0x00000002
#define  PDC5_SER_CTL_SB_TX_ERR		0x00000004
#define  PDC5_SER_CTL_SB_SLV_DONE	0x00000008
#define  PDC5_SER_CTL_SB_BUS_BSY	0x00000010
#define  PDC5_SER_CTL_SB_ST_BSY		0x00000020
#define  PDC5_SER_CTL_SB_ERR		0x00000040
#define  PDC5_SER_CTL_MASK_SB_MS_DONE	0x00000100
#define  PDC5_SER_CTL_MASK_SB_CMD_ERR	0x00000200
#define  PDC5_SER_CTL_MASK_SB_TX_ERR	0x00000400
#define  PDC5_SER_CTL_MASK_SB_SLV_DONE	0x00000800
#define  PDC5_SER_CTL_SB_RESET		0x00001000
#define  PDC5_SER_CTL_ST_OUT		0x0000c000
#define  PDC5_SER_CTL_SPEED		0x00010000
#define  PDC5_SER_CTL_TIMING		0x00020000
#define  PDC5_SER_CTL_SLAVE_MODE	0x01000000
#define  PDC5_SER_CTL_SLAVE_ADDR	0xfe000000
#define PDC5_SER_MS_CMD_ADDR	0x68
#define PDC5_SER_CURRENT_MASTER	0x6c
#define  PDC5_SER_CURRENT_MASTER_CMD	0x0000ffff
#define  PDC5_SER_CURRENT_MASTER_CNT	0x07ff0000
#define PDC5_I2C_RX_COUNT	0x70
#define  PDC5_I2C_RX_COUNT_RX_BYT_CNT	0x000007ff
#define  PDC5_I2C_RX_COUNT_BYT_CNT_ST	0x07ff0000
#define PDC5_SER_BASE_RX_ADDR	0x74
#define PDC5_SER_UPER_ADDR	0x78
#define PDC5_TBG_MODE		0x7c
#define  PDC5_TBG_MODE_N		0x000000ff
#define  PDC5_TBG_MODE_M		0x00000f00
#define  PDC5_TBG_MODE_DIVSEL		0x00003000
#define  PDC5_TBG_MODE_MN_ENABLE	0x00004000
#define  PDC5_TBG_MODE_CNFG		0x00030000
#define  PDC5_TBG_MODE_ICHIP		0x00300000
#define  PDC5_TBG_MODE_TBG_SEL		0x03000000
#define  PDC5_TBG_MODE_PERIOD_SEL	0x1c000000
#define  PDC5_TBG_MODE_CKDIV		0x60000000
#define  PDC5_TBG_MODE_LOOPBACK		0x80000000
#define PDC5_SLEW_CTL		0x80

#define PORT_DATA		0x00
#define PORT_FEATURES		0x04
#define PORT5_EXP_FEATURES	0x05
#define PORT_ERROR		0x04
#define PORT_COUNT		0x08
#define PORT5_EXP_COUNT		0x09
#define PORT_LBA_L		0x0c
#define PORT5_EXP_LBA_L		0x0d
#define PORT_LBA_M		0x10
#define PORT5_EXP_LBA_M		0x11
#define PORT_LBA_H		0x14
#define PORT5_EXP_LBA_H		0x15
#define PORT_DRIVE		0x18
#define PORT_CMD		0x1c
#define PORT_STATUS		0x1c
#define PORT_STATUS_FP_SMA_ST		0x00000100
#define PORT_ALTSTATUS		0x38
#define PORT_CTRL		0x38
#define PORT_PKT_SUBMIT		0x40
#define PORT_DESC_TABLE		0x44
#define PORT_G_CTL_STAT		0x48
#define  PORT_G_CTL_STAT_NCA_PAUSE	0x00000001
#define  PORT5_G_CTL_STAT_PKT_A_TA_DRQ	0x00000010
#define  PORT5_G_CTL_STAT_PKT_A_TA_BSY	0x00000020
#define  PORT_G_CTL_STAT_PH_ERR		0x00000100
#define  PORT_G_CTL_STAT_SH_ERR		0x00000200
#define  PORT_G_CTL_STAT_DH_ERR		0x00000400
#define  PORT5_G_CTL_STAT_HTO_ERR	0x00001000
#define  PORT5_G_CTL_STAT_HB_ERR	0x00002000
#define  PORT5_G_CTL_STAT_DMACNT_ERR	0x00004000
#define  PORT_G_CTL_STAT_PACKET_COMPL	0x00010000
#define  PORT_G_CTL_STAT_DIRECT_COMPL	0x00020000
#define  PORT_G_CTL_STAT_OVERRUN	0x00080000
#define  PORT_G_CTL_STAT_UNDERRUN	0x00100000
#define  PORT_G_CTL_STAT_DRIVE_ERROR	0x00200000
#define  PORT_G_CTL_STAT_PCI_ERROR	0x00400000
#define  PORT_G_CTL_STAT_PARITY_ERROR	0x00400000
#define  PORT_G_CTL_STAT_DELAY_TX	0x10000000
#define  PORT_G_CTL_STAT_COMMAND_CYCLE	0x20000000
#define  PORT5_G_CTL_STAT_FPDMA_CYCLE	0x40000000
#define PORT_DRV0_CFG0		0x4c
#define  PORT_DRV0_CFG0_TPENV		0x0000001f
#define  PORT_DRV0_CFG0_TPRCV		0x000000e0
#define  PORT_DRV0_CFG0_TPRCYC		0x00003f00
#define  PORT_DRV0_CFG0_TDCYCL		0x001f0000
#define  PORT_DRV0_CFG0_TDENV		0x00e00000
#define  PORT_DRV0_CFG0_TDCYCH		0x1f000000
#define  PORT_DRV0_CFG0_TDN		0x60000000
#define PORT_DRV0_CFG1		0x50
#define  PORT_DRV0_CFG1_TACK		0x00000003
#define  PORT_DRV0_CFG1_TENV		0x0000000c
#define  PORT_DRV0_CFG1_TMLI		0x000000f0
#define  PORT_DRV0_CFG1_TCYC		0x00001f00
#define  PORT_DRV0_CFG1_THOLD		0x00002000
#define  PORT_DRV0_CFG1_TRP		0x001f0000
#define  PORT_DRV0_CFG1_TSS		0x00e00000
#define  PORT_DRV0_CFG1_PIO_IORDY	0x01000000
#define  PORT_DRV0_CFG1_TPDCYC		0xfc000000
#define PORT_SG_ADDRESS		0x54
#define PORT_SG_BYTE_COUNT	0x58
#define PORT_SG_NEXT_COMMAND	0x5c
#define PORT_CTL_STAT		0x60
#define  PORT_CTL_STAT_SEQID		0x0000000f
#define  PORT_CTL_STAT_DMADIR_TO_DEVICE	0x00000040
#define  PORT_CTL_STAT_DMA_ENABLE	0x00000080
#define  PORT_CTL_STAT_ATA_TEST		0x00000200
#define  PORT_CTL_STAT_MASK_INT		0x00000400
#define  PORT_CTL_STAT_ATA_RESET	0x00000800
#define  PORT_CTL_STAT_CABLE_40		0x01000000
#define  PORT5_CTL_STAT_INT_EDGE	0x04000000
#define  PORT_CTL_STAT_INT		0x08000000
#define  PORT_CTL_STAT_DMARQ		0x10000000
#define  PORT_CTL_STAT_CTRL_FIFO_EMPTY	0x40000000
#define  PORT_CTL_STAT_DATA_FIFO_EMPTY	0x80000000

#define PORT2_SATA_STATUS	0x00
#define  PORT2_SATA_STATUS_PHY_STATE	0x0000000f
#define  PORT2_SATA_STATUS_SPEED	0x000000f0
#define  PORT2_SATA_STATUS_POWER_MGMT	0x00000f00
#define PORT2_SATA_ERROR	0x04
#define  PORT2_SATA_ERROR_RECOVERED	0x00000001
#define  PORT2_SATA_ERROR_COMM_ERR	0x00000002
#define  PORT2_SATA_ERROR_NR_TRANSIENT	0x00000100
#define  PORT2_SATA_ERROR_NR_PERSISTENT	0x00000200
#define  PORT2_SATA_ERROR_PROTOCOL	0x00000400
#define  PORT2_SATA_ERROR_COMWAKE	0x00040000
#define  PORT2_SATA_ERROR_10_8		0x00080000
#define  PORT2_SATA_ERROR_DISPARITY	0x00100000
#define  PORT2_SATA_ERROR_CRC		0x00200000
#define  PORT2_SATA_ERROR_LINK_SEQ	0x00800000
#define  PORT2_SATA_ERROR_FIS_TYPE	0x02000000
#define PORT2_SATA_SCONTROL	0x08
#define  PORT2_SATA_SCONTROL_INIT	0x0000000f
#define  PORT2_SATA_SCONTROL_SPEED	0x000000f0
#define  PORT2_SATA_SCONTROL_POWER_MGMT	0x00000f00
#define PORT2_SATA_CONTROL	0x0c
#define  PORT2_SATA_CONTROL_SS_CLOCK	0x00800000
#define  PORT2_SATA_CONTROL_SQUELCH	0x00000003
#define PORT2_BIST_DW0		0x10
#define PORT2_BIST_DW1		0x14
#define PORT2_BIST_DW2		0x18
#define PORT2_PM_TRIGGER	0x30
#define  PORT2_PM_TRIGGER_FIFO_HOLD	0x00001f00
#define  PORT2_PM_TRIGGER_CMD_DRQ_ABORT	0x00010000
#define  PORT2_PM_TRIGGER_UDMA_FIX	0x00020000
#define  PORT2_PM_TRIGGER_BAD_CRC_IGN	0x00040000
#define  PORT2_PM_TRIGGER_PM_DISABLE	0x00080000
#define  PORT2_PM_TRIGGER_CRC_DISABLE	0x04000000
#define  PORT2_PM_TRIGGER_RXSC_DISABLE	0x08000000
#define  PORT2_PM_TRIGGER_TXSC_DISABLE	0x10000000
#define  PORT2_PM_TRIGGER_TXCN_DISABLE	0x20000000
#define PORT2_PM		0x3c
#define  PORT2_PM_BIST_RESULT		0x00070000
#define   PORT2_PM_BIST_RESULT_OK_1		0x00040000
#define   PORT2_PM_BIST_RESULT_OK_2		0x00050000
#define  PORT2_PM_BIST_FIS		0x00100000
#define  PORT2_PM_BIST			0x00200000
#define PORT2_SATA_MODE		0x74
#define  PORT2_SATA_MODE_AMP		0x000000e0
#define  PORT2_SATA_MODE_PPL_BW		0x00000600
#define  PORT2_SATA_MODE_PRE		0x00003000
#define  PORT2_SATA_MODE_FREQ_MULTI	0x01800000
#define  PORT2_SATA_MODE_PHASE_COUNTER	0x06000000
#define  PORT2_SATA_MODE_PHY_READY	0x80000000

#define PORT5_LTMODE		0x0c
#define  PORT5_LTMODE_RCV_WM		0x0000003f
#define PORT5_PHYMODE4		0x14
#define  PORT5_PHYMODE4_ALIGN_TIMING	0x00000003
#define  PORT5_PHYMODE4_OOB_BYPASS	0x80000000
#define PORT5_PHYMODE2		0x30
#define  PORT5_PHYMODE2_TXAMP		0x00000700
#define  PORT5_PHYMODE2_TXPRE		0x000000e0
#define PORT5_BIST_CTL		0x34
#define PORT5_BIST_DW1		0x38
#define PORT5_BIST_DW2		0x3c
#define PORT5_REGISTER_H2D	0x40
#define  PORT5_REGISTER_H2D_RVD_D	0x00007000
#define  PORT5_REGISTER_H2D_BIST_INT	0x00100000
#define  PORT5_REGISTER_H2D_INT_MASK	0x00200000
#define  PORT5_REGISTER_H2D_ACT_FIS	0xff000000
#define PORT5_DATA_H2D		0x44
#define  PORT5_DATA_H2D_RVD_D		0xfffff000
#define PORT5_BIST_DATA_DW1	0x48
#define PORT5_FIST_D2H		0x4c
#define PORT5_MISC_CTL		0x50
#define  PORT5_MISC_CTL_RX_BIST_DW2	0x00ffffff
#define  PORT5_MISC_CTL_SCC_EN		0x40000000
#define  PORT5_MISC_CTL_I_SRST		0x80000000
#define PORT5_FIS_DATA_0	0x54
#define  PORT5_FIS_DATA_0_REGFIS	0x000000ff
#define  PORT5_FIS_DATA_0_PIOSETUP	0x0000ff00
#define  PORT5_FIS_DATA_0_DMASETUP	0x00ff0000
#define  PORT5_FIS_DATA_0_DMAACTIVATE	0xff000000
#define PORT5_FIS_DATA_1	0x58
#define  PORT5_FIS_DATA_1_SET_DEVICE	0x000000ff
#define  PORT5_FIS_DATA_1_DATAFIS	0x0000ff00
#define  PORT5_FIS_DATA_1_RX_BIST_1	0x00ff0000
#define  PORT5_FIS_DATA_1_RX_BIST_2	0xff000000
#define PORT5_DW0_BIST_FIS_H2D	0x5c
#define  PORT5_DW0_BIST_FIS_H2D_REQUEST	0x000000ff
#define  PORT5_DW0_BIST_FIS_H2D_DATA	0xffffff00
#define PORT5_DW1_BIST_FIS_H2D	0x60
#define PORT5_DW2_BIST_FIS_H2D	0x64
#define PORT5_DW_PIO		0x68
#define PORT5_FPDMA		0x80
#define  PORT5_FPDMA_OFFSET_N		0x0000ffff
#define  PORT5_FPDMA_OFFSET_N1		0xffff0000
#define PORT5_FPDMA_HIGH	0xc0
#define  PORT5_FPDMA_HIGH_MASK		0xffff0000
#define PORT5_FPDMA_CMD_PACKET	0xc8
#define PORT5_FPDMA_DESC_TABLE	0xcc
#define PORT5_ATA_CTL		0xd0
#define  PORT5_ATA_CTL_ENCRYPT		0x00000002
#define  PORT5_ATA_CTL_LED_ON		0x00000100
#define PORT5_FPDMA_CS		0xd8
#define  PORT5_FPDMA_CS_HW_SETUP	0x00000002
#define  PORT5_FPDMA_CS_PACKET_PTR	0x00000004
#define  PORT5_FPDMA_CS_RESET		0x00000008
#define  PORT5_FPDMA_CS_RW_TO_HOST	0x00000040
#define  PORT5_FPDMA_CS_START		0x00000080
#define  PORT5_FPDMA_CS_DMA_INT_MASK	0x00000100
#define  PORT5_FPDMA_CS_SETDEV_INT_MASK	0x00000200
#define  PORT5_FPDMA_CS_DMA_INT		0x00000400
#define  PORT5_FPDMA_CS_SETDEV_INT	0x00000800
#define  PORT5_FPDMA_CS_D2H_FIST_INT	0x00001000
#define  PORT5_FPDMA_CS_FPDMA_READY	0x00002000
#define  PORT5_FPDMA_CS_FPDMA_BUSY	0x00004000
#define  PORT5_FPDMA_CS_TAG		0x001f0000
#define  PORT5_FPDMA_CS_DMA_RW_TO_HOST	0x00200000
#define  PORT5_FPDMA_CS_AUTOACT		0x00400000
#define  PORT5_FPDMA_CS_DMA_REMPTY	0x01000000
#define  PORT5_FPDMA_CS_DMA_TFULL	0x02000000
#define  PORT5_FPDMA_CS_DA_F_EMPTY	0x04000000
#define  PORT5_FPDMA_CS_DA_F_FULL	0x08000000
#define  PORT5_FPDMA_CS_DMA_REQ		0x10000000
#define  PORT5_FPDMA_CS_AD_F_DMACT	0x20000000
#define PORT5_FPDMA_SACTIVE	0xdc
#define PORT5_PIO_COUNT		0xe0
#define PORT5_FPDMA_COUNT	0xe4
#define PORT5_PM_PORT		0xe8
#define PORT5_FPDMA_BUF_OFF	0xec

typedef struct {
	__u8 control;
	__u8 pm_port5;
	__u8 sync_seq;
	__u8 delay_seq;
	__u32 psg;
	__u32 nca;
	__u8 cmd[52];	/* align for 64-bit cacheline */
			/* note, cmd needs to be at least 4 bytes more than
			   maximal command size, so that reading register back
			   won't point to another command */
} CMD_PACKET;

#define CMD_PACKET_ALIGN	64

#define CONTROL_DMA_READ	0x04
#define CONTROL_NODATA		0x08
#define CONTROL_DELAY_ENABLE	0x10
#define CONTROL_NCA_PAUSE	0x20
#define CONTROL5_SWAP_BOX	0x40
#define CONTROL5_FPDMA		0x80

#define CMD_NUMBER		0xe0
#define  CMD_N(n)			(((n) << 5) & CMD_NUMBER)
#define CMD_CONDITION		0x18
#define  CMD_CONDITION_UNCOND		0x00
#define  CMD_CONDITION_EOP		0x08
#define  CMD_CONDITION_BSY		0x10
#define  CMD_CONDITION_DRDY		0x18
#define CMD_REG			0x07
#define  CMD_REG_DATA			0x00
#define  CMD_REG_FEATURES		0x01
#define  CMD_REG_COUNT			0x02
#define  CMD_REG_LBA_L			0x03
#define  CMD_REG_LBA_M			0x04
#define  CMD_REG_LBA_H			0x05
#define  CMD_REG_DRIVE			0x06
#define  CMD_REG_CMD			0x07
#define  CMD_REG_CTL			0x0e

#endif
