#include <SPAD/ATA.H>

static int match_string(const char *pattern, const char *model)
{
	int prefix = 0;
	size_t len = strlen(pattern);
	while (len) {
		if (__unlikely(pattern[len - 1] == '*')) {
			len--;
			prefix = 1;
		} else {
			break;
		}
	}
	if (!prefix)
		return len == strlen(model) && !memcmp(pattern, model, len);
	else
		return !strncmp(pattern, model, len);
}

unsigned ATA$BLACKLIST_SEARCH(const char * const blacklist[], const __u16 ident[256])
{
	const char *pattern;
	char model[41];
	ATA$GET_MODEL(ident, &model, NULL, NULL);
	while ((pattern = *blacklist++)) {
		if (__unlikely(match_string(pattern, model)))
			return 1;
	}
	return 0;

}

void ATA$BLACKLIST_RESTRICT(const char * const blacklist[], const __u16 ident[256], unsigned mask, unsigned *avail, unsigned *avail_unsupported)
{
	if (ATA$BLACKLIST_SEARCH(blacklist, ident)) {
		*avail_unsupported = *avail & mask;
		*avail &= ~mask;
	}
}
