#include <SYS/TYPES.H>
#include <STRING.H>

#include <SPAD/ATA.H>

/* Taken from Linux (C) Jeff Garzik <jgarzik@pobox.com>
   I don't understand what it does :) */

static const struct ata_timing PIO_TIMING[7] = {
	/* IDE_XFER_PIO_0, */    70, 290, 240, 600, 165, 150, 600,  0,
	/* IDE_XFER_PIO_1, */    50, 290,  93, 383, 125, 100, 383,  0,
	/* IDE_XFER_PIO_2, */    30, 290,  40, 330, 100,  90, 240,  0,
	/* IDE_XFER_PIO_3, */    30,  80,  70, 180,  80,  70, 180,  0,
	/* IDE_XFER_PIO_4, */    25,  70,  25, 120,  70,  25, 120,  0,
	/* IDE_XFER_PIO_5, */    15,  65,  25, 100,  65,  25, 100,  0,
	/* IDE_XFER_PIO_6, */    10,  55,  20,  80,  55,  20,  80,  0,
};

static const struct ata_timing DMA_TIMING[N_DMA_MODES] = {
	/* IDE_XFER_SDMA_0, */  120,   0,   0,   0, 480, 480, 960,   0,
	/* IDE_XFER_SDMA_1, */   90,   0,   0,   0, 240, 240, 480,   0,
	/* IDE_XFER_SDMA_2, */   60,   0,   0,   0, 120, 120, 240,   0,
	/* IDE_XFER_WDMA_0, */   60,   0,   0,   0, 215, 215, 480,   0,
	/* IDE_XFER_WDMA_1, */   45,   0,   0,   0,  80,  50, 150,   0,
	/* IDE_XFER_WDMA_2, */   25,   0,   0,   0,  70,  25, 120,   0,
	/* IDE_XFER_WDMA_3, */   25,   0,   0,   0,  65,  25, 100,   0,
	/* IDE_XFER_WDMA_4, */   25,   0,   0,   0,  55,  20,  80,   0,
	/* IDE_XFER_UDMA_0, */    0,   0,   0,   0,   0,   0,   0, 120,
	/* IDE_XFER_UDMA_1, */    0,   0,   0,   0,   0,   0,   0,  80,
	/* IDE_XFER_UDMA_2, */    0,   0,   0,   0,   0,   0,   0,  60,
	/* IDE_XFER_UDMA_3, */    0,   0,   0,   0,   0,   0,   0,  45,
	/* IDE_XFER_UDMA_4, */    0,   0,   0,   0,   0,   0,   0,  30,
	/* IDE_XFER_UDMA_5, */    0,   0,   0,   0,   0,   0,   0,  20,
	/* IDE_XFER_UDMA_6, */    0,   0,   0,   0,   0,   0,   0,  15,
};

void ATA$INIT_TIMING(struct ata_timing *t)
{
	memset(t, 0, sizeof(struct ata_timing));
}

void ATA$MERGE_PIO_TIMING(struct ata_timing *t, unsigned pio, unsigned what)
{
	if (__unlikely(pio >= sizeof(PIO_TIMING) / sizeof(*PIO_TIMING)))
		return;
	ATA$MERGE_TIMING(t, &PIO_TIMING[pio], what);
}

void ATA$MERGE_DMA_TIMING(struct ata_timing *t, unsigned dma, unsigned what)
{
	if (__unlikely(dma >= sizeof(DMA_TIMING) / sizeof(*DMA_TIMING)))
		return;
	ATA$MERGE_TIMING(t, &DMA_TIMING[dma], what);
}

void ATA$MERGE_TIMING(struct ata_timing *t, const struct ata_timing *m, unsigned what)
{
	if (what & ATA_MERGE_SETUP && t->setup < m->setup) t->setup = m->setup;
	if (what & ATA_MERGE_ACT8B && t->act8b < m->act8b) t->act8b = m->act8b;
	if (what & ATA_MERGE_REC8B && t->rec8b < m->rec8b) t->rec8b = m->rec8b;
	if (what & ATA_MERGE_CYC8B && t->cyc8b < m->cyc8b) t->cyc8b = m->cyc8b;
	if (what & ATA_MERGE_ACTIVE && t->active < m->active) t->active = m->active;
	if (what & ATA_MERGE_RECOVER && t->recover < m->recover) t->recover = m->recover;
	if (what & ATA_MERGE_CYCLE && t->cycle < m->cycle) t->cycle = m->cycle;
	if (what & ATA_MERGE_UDMA && t->udma < m->udma) t->udma = m->udma;
}

void ATA$QUANTIZE_TIMING(struct ata_timing *t, unsigned bus, unsigned udma_bus)
{
	t->setup = (t->setup * bus + 999999) / 1000000;
	t->act8b = (t->act8b * bus + 999999) / 1000000;
	t->rec8b = (t->rec8b * bus + 999999) / 1000000;
	t->cyc8b = (t->cyc8b * bus + 999999) / 1000000;
	t->active = (t->active * bus + 999999) / 1000000;
	t->recover = (t->recover * bus + 999999) / 1000000;
	t->cycle = (t->cycle * bus + 999999) / 1000000;
	t->udma = (t->udma * udma_bus + 999999) / 1000000;

	if (t->act8b + t->rec8b < t->cyc8b) {
		t->act8b += (t->cyc8b - (t->act8b + t->rec8b)) / 2;
		t->rec8b = t->cyc8b - t->act8b;
	}

	if (t->active + t->recover < t->cycle) {
		t->active += (t->cycle - (t->active + t->recover)) / 2;
		t->recover = t->cycle - t->active;
	}

	if (t->active + t->recover > t->cycle)
		t->cycle = t->active + t->recover;
}

unsigned ATA$FIT_TIMING(unsigned val, unsigned min, unsigned max, unsigned sub)
{
	if (val > max) val = max;
	if (val < min) val = min;
	return val - sub;
}
