#include <SYS/TYPES.H>
#include <ENDIAN.H>
#include <SPAD/SYSLOG.H>
#include <SPAD/BIO_KRNL.H>
#include <UNISTD.H>

#include <SPAD/ATA.H>

static const struct {
	__u8 cmd;
	short feature;
	const char *name;
} command_names[] = {
{ ATA_CMD_NOP, -1, "NOP" },
{ ATA_CMD_NOP, ATA_FEATURE_NOP_NOP, "NOP" },
{ ATA_CMD_NOP, ATA_FEATURE_NOP_AUTO_POLL, "AUTO POLL" },
{ ATA_CMD_READ, -1, "READ" },
{ ATA_CMD_READ_EXT, -1, "READ EXT" },
{ ATA_CMD_READ_DMA_EXT, -1, "READ DMA EXT" },
{ ATA_CMD_READ_DMA_QUEUED_EXT, -1, "READ DMA QUEUED EXT" },
{ ATA_CMD_READ_NATIVE_MAX_ADDRESS_EXT, -1, "READ NATIVE MAX ADDRESS EXT" },
{ ATA_CMD_READ_MULTIPLE_EXT, -1, "READ MULTIPLE EXT" },
{ ATA_CMD_WRITE, -1, "WRITE" },
{ ATA_CMD_WRITE_EXT, -1, "WRITE EXT" },
{ ATA_CMD_WRITE_DMA_EXT, -1, "WRITE DMA EXT" },
{ ATA_CMD_WRITE_DMA_QUEUED_EXT, -1, "WRITE DMA QUEUED EXT" },
{ ATA_CMD_SET_MAX_ADDRESS_EXT, -1, "SET MAX ADDRESS EXT" },
{ ATA_CMD_WRITE_MULTIPLE_EXT, -1, "WRITE MULTIPLE EXT" },
{ ATA_CMD_PACKET, -1, "PACKET" },
{ ATA_CMD_IDENTIFY_PACKET_DEVICE, -1, "IDENTIFY PACKET DEVICE" },
{ ATA_CMD_SERVICE, -1, "SERVICE" },
{ ATA_CMD_CONFIGURATION, -1, "CONFIGURATION" },
{ ATA_CMD_CONFIGURATION, ATA_FEATURE_CONFIGURATION_RESTORE, "RESTORE" },
{ ATA_CMD_CONFIGURATION, ATA_FEATURE_CONFIGURATION_FREEZE_LOCK, "FREEZE LOCK" },
{ ATA_CMD_CONFIGURATION, ATA_FEATURE_CONFIGURATION_IDENTIFY, "IDENTIFY" },
{ ATA_CMD_CONFIGURATION, ATA_FEATURE_CONFIGURATION_SET, "SET" },
{ ATA_CMD_READ_MULTIPLE, -1, "READ MULTIPLE" },
{ ATA_CMD_WRITE_MULTIPLE, -1, "WRITE MULTIPLE" },
{ ATA_CMD_SET_MULTIPLE_MODE, -1, "SET MULTIPLE MODE" },
{ ATA_CMD_READ_DMA_QUEUED, -1, "READ DMA QUEUED" },
{ ATA_CMD_READ_DMA, -1, "READ DMA" },
{ ATA_CMD_WRITE_DMA, -1, "WRITE DMA" },
{ ATA_CMD_WRITE_DMA_QUEUED, -1, "WRITE DMA QUEUED" },
{ ATA_CMD_FLUSH_CACHE, -1, "FLUSH CACHE" },
{ ATA_CMD_FLUSH_CACHE_EXT, -1, "FLUSH CACHE EXT" },
{ ATA_CMD_IDENTIFY_DEVICE, -1, "IDENTIFY DEVICE" },
{ ATA_CMD_SET_FEATURES, -1, "SET FEATURES" },
{ ATA_CMD_SET_FEATURES, ATA_FEATURE_SET_FEATURES_ENABLE_WCACHE, "ENABLE WRITE CACHE" },
{ ATA_CMD_SET_FEATURES, ATA_FEATURE_SET_FEATURES_XFER, "XFER" },
{ ATA_CMD_SET_FEATURES, ATA_FEATURE_SET_FEATURES_SPIN_UP, "SPIN UP" },
{ ATA_CMD_SET_FEATURES, ATA_FEATURE_SET_FEATURES_DISABLE_RCACHE, "DISABLE READ CACHE" },
{ ATA_CMD_SET_FEATURES, ATA_FEATURE_SET_FEATURES_ENABLE_REL_INT, "ENABLE RELEASE INTERRUPT" },
{ ATA_CMD_SET_FEATURES, ATA_FEATURE_SET_FEATURES_ENABLE_SERV_INT, "ENABLE SERVICE INTERRUPT" },
{ ATA_CMD_SET_FEATURES, ATA_FEATURE_SET_FEATURES_DISABLE_WCACHE, "DISABLE WRITE CACHE" },
{ ATA_CMD_SET_FEATURES, ATA_FEATURE_SET_FEATURES_ENABLE_RCACHE, "ENABLE READ CACHE" },
{ ATA_CMD_SET_FEATURES, ATA_FEATURE_SET_FEATURES_DISABLE_REL_INT, "DISABLE RELEASE INTERRUPT" },
{ ATA_CMD_SET_FEATURES, ATA_FEATURE_SET_FEATURES_DISABLE_SERV_INT, "DISABLE SERVICE INTERRUPT" },
{ ATA_CMD_READ_NATIVE_MAX_ADDRESS, -1, "READ NATIVE MAX ADDRESS" },
{ ATA_CMD_SET_MAX_ADDRESS, -1, "SET MAX ADDRESS" },
};

const char *ATA$COMMAND_NAME(__u8 cmd, __u8 feature)
{
	static char name[__MAX_STR_LEN];
	int i;
	const char *cmdname = NULL, *ftname = NULL;
	for (i = 0; i < sizeof(command_names) / sizeof(*command_names); i++) {
		if (__unlikely(command_names[i].cmd == cmd) && __likely(command_names[i].feature == -1)) cmdname = command_names[i].name;
		if (__unlikely(command_names[i].cmd == cmd) && __unlikely(command_names[i].feature == feature)) ftname = command_names[i].name;
	}
	if (cmdname) {
		if (!ftname) return cmdname;
		_snprintf(name, sizeof name, "%s / %s", cmdname, ftname);
		return name;
	}
	_snprintf(name, sizeof name, "%02X", cmd);
	return name;
}

int ATA$DUMMY_DEQUEUE(ATA_ATTACH_PARAM *ap)
{
	return BIO_DEQUEUE_EMPTY;
}

BIORQ *ATA$DUMMY_PROBE_QUEUE(ATA_ATTACH_PARAM *ap)
{
	return NULL;
}

int ATA$IS_ATAPI(const __u16 ident[256])
{
	return (ident[0] & 0xc000) == 0x8000;
}

void ATA$BSWAP_IDENTIFY(__u16 id[256])
{
#if defined(__ENDIAN_BIG)
	swab(id, id, 512);
#elif defined(__ENDIAN_LITTLE)
#else
	unknown endian
#endif
}

static void GET_MODEL_STRING(const __u16 *id, char *str, unsigned len, int swap);

void ATA$GET_MODEL(const __u16 id[256], char (*model)[41], char (*serial)[21], char (*revision)[9])
{
	int swap = 0;
	if (ATA$IS_ATAPI(id) && (
		id[27] == ('N' | ('E' << 8)) ||
		id[27] == ('F' | ('X' << 8)) ||
		id[27] == ('P' | ('i' << 8)))) swap = 1;
	if (model) GET_MODEL_STRING(id + 27, *model, 40, swap);
	if (serial) GET_MODEL_STRING(id + 10, *serial, 20, swap);
	if (revision) GET_MODEL_STRING(id + 23, *revision, 8, swap);
}

static void GET_MODEL_STRING(const __u16 *id, char *str, unsigned len, int swap)
{
	int i, ii;
#if defined(__ENDIAN_LITTLE)
	swap = !swap;
#endif
	if (!swap) memcpy(str, id, len);
	else swab(id, str, len);
	i = len;
	str[i] = 0;
	for (i--; i >= 0; i--) if (str[i] == ' ') str[i] = 0;
			       else break;
	for (i = 0, ii = 0; str[i]; i++)
		if (str[i] >= 32 && str[i] < 126)
			if (str[i] != ' ' || (ii && str[ii - 1] != ' ')) str[ii++] = str[i];
	str[ii] = 0;
}

