#include <SYS/TYPES.H>
#include <ARCH/BSF.H>
#include <SPAD/SYSLOG.H>

#include <SPAD/ATA.H>

unsigned ATA$GET_XFER_MODE(const __u16 id[256])
{
	int atapi = ATA$IS_ATAPI(id);
	unsigned avail_xfer = 0;
	if (id[53] & 2) {
		if (id[64] & 1) avail_xfer |= IDE_XFER_PIO_3;
		if (id[64] & 2) avail_xfer |= IDE_XFER_PIO_4;
	}
	if (avail_xfer & (IDE_XFER_PIO_3 | IDE_XFER_PIO_4)) {
		avail_xfer |= IDE_XFER_PIO_0 | IDE_XFER_PIO_1 | IDE_XFER_PIO_2;
	} else {
		if ((id[51] >> 8) >= 2) avail_xfer |= IDE_XFER_PIO_0 | IDE_XFER_PIO_1 | IDE_XFER_PIO_2;
		else if ((id[51] >> 8) == 1) avail_xfer |= IDE_XFER_PIO_0 | IDE_XFER_PIO_1;
		else avail_xfer |= IDE_XFER_PIO_0;
	}
	if (id[63] & 1) avail_xfer |= IDE_XFER_WDMA_0;
	if (id[63] & 2) avail_xfer |= IDE_XFER_WDMA_0 | IDE_XFER_WDMA_1;
	if (id[63] & 4) avail_xfer |= IDE_XFER_WDMA_0 | IDE_XFER_WDMA_1 | IDE_XFER_WDMA_2;
	if (id[53] & 4) {
		if (id[88] & 1) avail_xfer |= IDE_XFER_UDMA_0;
		if (id[88] & 2) avail_xfer |= IDE_XFER_UDMA_0 | IDE_XFER_UDMA_1;
		if (id[88] & 4) avail_xfer |= IDE_XFER_UDMA_0 | IDE_XFER_UDMA_1 | IDE_XFER_UDMA_2;
		if (id[88] & 8) avail_xfer |= IDE_XFER_UDMA_0 | IDE_XFER_UDMA_1 | IDE_XFER_UDMA_2 | IDE_XFER_UDMA_3;
		if (id[88] & 16) avail_xfer |= IDE_XFER_UDMA_0 | IDE_XFER_UDMA_1 | IDE_XFER_UDMA_2 | IDE_XFER_UDMA_3 | IDE_XFER_UDMA_4;
		if (id[88] & 32) avail_xfer |= IDE_XFER_UDMA_0 | IDE_XFER_UDMA_1 | IDE_XFER_UDMA_2 | IDE_XFER_UDMA_3 | IDE_XFER_UDMA_4 | IDE_XFER_UDMA_5;
		if (id[88] & 64) avail_xfer |= IDE_XFER_UDMA_0 | IDE_XFER_UDMA_1 | IDE_XFER_UDMA_2 | IDE_XFER_UDMA_3 | IDE_XFER_UDMA_4 | IDE_XFER_UDMA_5 | IDE_XFER_UDMA_6;
	}
	if (atapi && id[62] & 0x8000) {
		if (id[62] & 0x0001) avail_xfer |= IDE_XFER_UDMA_0;
		if (id[62] & 0x0002) avail_xfer |= IDE_XFER_UDMA_0 | IDE_XFER_UDMA_1;
		if (id[62] & 0x0004) avail_xfer |= IDE_XFER_UDMA_0 | IDE_XFER_UDMA_1 | IDE_XFER_UDMA_2;
		if (id[62] & 0x0008) avail_xfer |= IDE_XFER_UDMA_0 | IDE_XFER_UDMA_1 | IDE_XFER_UDMA_2 | IDE_XFER_UDMA_3;
		if (id[62] & 0x0010) avail_xfer |= IDE_XFER_UDMA_0 | IDE_XFER_UDMA_1 | IDE_XFER_UDMA_2 | IDE_XFER_UDMA_3 | IDE_XFER_UDMA_4;
		if (id[62] & 0x0020) avail_xfer |= IDE_XFER_UDMA_0 | IDE_XFER_UDMA_1 | IDE_XFER_UDMA_2 | IDE_XFER_UDMA_3 | IDE_XFER_UDMA_4 | IDE_XFER_UDMA_5;
		if (id[62] & 0x0040) avail_xfer |= IDE_XFER_UDMA_0 | IDE_XFER_UDMA_1 | IDE_XFER_UDMA_2 | IDE_XFER_UDMA_3 | IDE_XFER_UDMA_4 | IDE_XFER_UDMA_5 | IDE_XFER_UDMA_6;
		if (id[62] & 0x0080) avail_xfer |= IDE_XFER_WDMA_0;
		if (id[62] & 0x0100) avail_xfer |= IDE_XFER_WDMA_1;
		if (id[62] & 0x0200) avail_xfer |= IDE_XFER_WDMA_2;
	}
	return avail_xfer;
}

unsigned ATA$XFER_GET_NUMBER(unsigned val, unsigned mask)
{
	if (__unlikely(!(mask & val)) || __unlikely(val & (val - 1)))
		KERNEL$SUICIDE("ATA$XFER_GET_NUMBER: VALUE %X, MASK %X", val, mask);
	return __BSF(val) - __BSF(mask);
}

unsigned ATA$XFER_BEST(unsigned mask)
{
	if (__unlikely(!mask)) return mask;
	return 1 << __BSR(mask);
}

static int TEST_BAD_XFER(unsigned xfer, unsigned drive_xfer_mask, unsigned controller_xfer_mask, const char *dev, const char *mode, unsigned n)
{
	const char *uns;
	int drive_bad = !(drive_xfer_mask & xfer);
	int ctrl_bad = !(controller_xfer_mask & xfer);
	if (drive_bad) {
		/* Allow drive overclocking */
		if (drive_xfer_mask & IDE_XFER_MASK_PIO && xfer & IDE_XFER_MASK_PIO) drive_bad = 0;
		if (drive_xfer_mask & IDE_XFER_MASK_SDMA && xfer & IDE_XFER_MASK_SDMA) drive_bad = 0;
		if (drive_xfer_mask & IDE_XFER_MASK_WDMA && xfer & IDE_XFER_MASK_WDMA) drive_bad = 0;
		if (drive_xfer_mask & IDE_XFER_MASK_UDMA && xfer & IDE_XFER_MASK_UDMA) drive_bad = 0;
	}
	if (!(drive_bad | ctrl_bad)) return 0;
	if (drive_bad & ctrl_bad) uns = "DRIVE AND CONTROLLER DON'T";
	else if (drive_bad) uns = "DRIVE DOESN'T";
	else uns = "CONTROLLER DOESN'T";
	KERNEL$SYSLOG(__SYSLOG_HW_INCOMPATIBILITY, dev, "%s SUPPORT %s MODE %d", uns, mode, n);
	return -EOPNOTSUPP;
}

static unsigned SELECT_DRIVE_XFER(unsigned xfer, unsigned drive_xfer)
{
	unsigned mask, x;
	if (xfer & IDE_XFER_MASK_PIO) mask = IDE_XFER_MASK_PIO;
	else if (xfer & IDE_XFER_MASK_SDMA) mask = IDE_XFER_MASK_SDMA;
	else if (xfer & IDE_XFER_MASK_WDMA) mask = IDE_XFER_MASK_WDMA;
	else if (xfer & IDE_XFER_MASK_UDMA) mask = IDE_XFER_MASK_UDMA;
	else KERNEL$SUICIDE("SELECT_DRIVE_XFER: UNSUPPORTED OVERCLOCKING, XFER %X, DRIVE_XFER %X", xfer, drive_xfer);
	for (x = xfer; x & mask; x <<= 1)
		if (x & drive_xfer)
			return x;
	for (x = xfer; x & mask; x >>= 1)
		if (x & drive_xfer)
			return x;
	KERNEL$SUICIDE("SELECT_DRIVE_XFER: UNSUPPORTED OVERCLOCKING, XFER %X, DRIVE_XFER %X", xfer, drive_xfer);
	return xfer;
}

static int SETUP_PIO_XFER(ATA_ATTACH_PARAM *ap, const __u16 id[256], unsigned users_xfer, unsigned drive_xfer_mask, unsigned controller_xfer_mask, unsigned controller_xfer_mask_unsupported, int (*set_pio)(APORT *p, int drive, unsigned pio, const __u16 id[256]), u_jiffies_lo_t timeout)
{
	ATARQ rq;
	unsigned xfer;
	int pio, r;
	xfer = users_xfer & IDE_XFER_MASK_PIO;
	if (!xfer) {
		xfer = ATA$XFER_BEST(controller_xfer_mask & drive_xfer_mask & IDE_XFER_MASK_PIO);
	}
	if (!xfer) return 0;
	pio = ATA$XFER_GET_NUMBER(xfer, IDE_XFER_MASK_PIO);
	if ((r = TEST_BAD_XFER(xfer, drive_xfer_mask, controller_xfer_mask | controller_xfer_mask_unsupported, *ap->dev_name, "PIO", pio))) return r;
	if ((r = set_pio(ap->port, ap->device, xfer, id))) {
		KERNEL$SYSLOG(__SYSLOG_HW_INCOMPATIBILITY, *ap->dev_name, "ATA CONTROLLER REFUSED TO SET PIO MODE %d: %s", pio, strerror(-r));
		return r;
	}
	pio = ATA$XFER_GET_NUMBER(SELECT_DRIVE_XFER(xfer, drive_xfer_mask), IDE_XFER_MASK_PIO);
	memset(&rq.fis, 0, sizeof rq.fis);
	rq.fis.feature0 = ATA_FEATURE_SET_FEATURES_XFER;
	rq.fis.nsect0 = ATA_SET_XFER_PIO | pio;
	rq.fis.command = ATA_CMD_SET_FEATURES;
	rq.atarq_flags = ATA_PROTOCOL_NODATA | ATARQ_VALID_FEATURE;
	if (pio <= 2) rq.atarq_flags |= ATARQ_ERROR_ALLOW_ABORT;
	/*__debug_printf("set pio: %x\n", rq.fis.nsect0);*/
	ATA$SYNC_RQ(&rq, ap, NULL, 0, timeout, 0);
	if (pio > 2 && rq.status)
		return rq.status;
	return xfer;
}

static int SETUP_DMA_XFER(ATA_ATTACH_PARAM *ap, const __u16 id[256], unsigned users_xfer, unsigned drive_xfer_mask, unsigned controller_xfer_mask, unsigned controller_xfer_mask_unsupported, int (*set_dma)(APORT *p, int drive, unsigned dma, const __u16 id[256]), u_jiffies_lo_t timeout)
{
	const char *desc;
	ATARQ rq;
	unsigned xfer, drive_xfer;
	int dma, r;
	int can_fail;
	xfer = users_xfer & IDE_XFER_MASK_DMA;
	if (!xfer) {
		xfer = ATA$XFER_BEST(controller_xfer_mask & drive_xfer_mask & IDE_XFER_MASK_DMA);
	}
	if (!xfer) {
		if (!controller_xfer_mask && drive_xfer_mask & IDE_XFER_MASK_DMA)
			return 0; /* Let it be as it was set by BIOS */
		return -EOPNOTSUPP;
	}
	if (xfer & IDE_XFER_MASK_SDMA) dma = ATA$XFER_GET_NUMBER(xfer, IDE_XFER_MASK_SDMA), desc = "SDMA";
	else if (xfer & IDE_XFER_MASK_WDMA) dma = ATA$XFER_GET_NUMBER(xfer, IDE_XFER_MASK_WDMA), desc = "WDMA";
	else if (xfer & IDE_XFER_MASK_UDMA) dma = ATA$XFER_GET_NUMBER(xfer, IDE_XFER_MASK_UDMA), desc = "UDMA";
	else KERNEL$SUICIDE("ATA$SETUP_DMA_XFER: NO DMA FLAGS IN XFER %X", xfer);
	if ((r = TEST_BAD_XFER(xfer, drive_xfer_mask, controller_xfer_mask | controller_xfer_mask_unsupported, *ap->dev_name, desc, dma))) return r;
	if ((r = set_dma(ap->port, ap->device, xfer, id))) {
		KERNEL$SYSLOG(__SYSLOG_HW_INCOMPATIBILITY, *ap->dev_name, "ATA CONTROLLER REFUSED TO SET %s MODE %d: %s", desc, dma, strerror(-r));
		return r;
	}

	drive_xfer = SELECT_DRIVE_XFER(xfer, drive_xfer_mask);
	if (drive_xfer & IDE_XFER_MASK_SDMA) dma = ATA$XFER_GET_NUMBER(drive_xfer, IDE_XFER_MASK_SDMA);
	else if (drive_xfer & IDE_XFER_MASK_WDMA) dma = ATA$XFER_GET_NUMBER(drive_xfer, IDE_XFER_MASK_WDMA);
	else if (drive_xfer & IDE_XFER_MASK_UDMA) dma = ATA$XFER_GET_NUMBER(drive_xfer, IDE_XFER_MASK_UDMA);
	else KERNEL$SUICIDE("ATA$SETUP_DMA_XFER: NO DMA FLAGS IN DRIVE_XFER %X", drive_xfer);

	can_fail = 0;
	if (xfer == IDE_XFER_WDMA_0) can_fail = 1;

	memset(&rq.fis, 0, sizeof rq.fis);
	rq.fis.feature0 = ATA_FEATURE_SET_FEATURES_XFER;
	if (xfer & IDE_XFER_MASK_SDMA) rq.fis.nsect0 = ATA_SET_XFER_SDMA | dma;
	else if (xfer & IDE_XFER_MASK_WDMA) rq.fis.nsect0 = ATA_SET_XFER_WDMA | dma;
	else rq.fis.nsect0 = ATA_SET_XFER_UDMA | dma;
	rq.fis.command = ATA_CMD_SET_FEATURES;
	rq.atarq_flags = ATA_PROTOCOL_NODATA | ATARQ_VALID_FEATURE;
	if (can_fail) rq.atarq_flags |= ATARQ_ERROR_ALLOW_ABORT;
	/*__debug_printf("set dma: %x\n", rq.fis.nsect0);*/
	ATA$SYNC_RQ(&rq, ap, NULL, 0, timeout, 0);
	if (!can_fail && rq.status)
		return rq.status;
	return xfer;
}

int ATA$SETUP_XFER(ATA_ATTACH_PARAM *ap, int dma, const __u16 id[256], unsigned users_xfer, unsigned drive_xfer_mask, unsigned controller_xfer_mask, unsigned controller_xfer_mask_unsupported, int (*set)(APORT *p, int drive, unsigned pio, const __u16 id[256]), u_jiffies_lo_t timeout)
{
	if (!dma) return SETUP_PIO_XFER(ap, id, users_xfer, drive_xfer_mask, controller_xfer_mask, controller_xfer_mask_unsupported, set, timeout);
	return SETUP_DMA_XFER(ap, id, users_xfer, drive_xfer_mask, controller_xfer_mask, controller_xfer_mask_unsupported, set, timeout);
}

int ATA$SET_XFER_EMPTY(APORT *p, int drive, unsigned pio, const __u16 id[256])
{
	return 0;
}

void ATA$CABLE40_RESTRICT(unsigned *controller_xfer_mask, unsigned *controller_xfer_mask_unsupported)
{
	const unsigned restricted = IDE_XFER_UDMA_3 | IDE_XFER_UDMA_4 | IDE_XFER_UDMA_5 | IDE_XFER_UDMA_6;
	*controller_xfer_mask_unsupported |= *controller_xfer_mask & restricted;
	*controller_xfer_mask &= ~restricted;
}

void ATA$CHECK_DEVICE_CABLE(const __u16 ident[256], unsigned *controller_xfer_mask, unsigned *controller_xfer_mask_unsupported)
{
	/*__debug_printf("ident 93 %04x\n", ident[93]);*/
	if ((ident[93] & 0xc000) != 0x4000) return;
	if (ident[93] & 0x2000) return;
	ATA$CABLE40_RESTRICT(controller_xfer_mask, controller_xfer_mask_unsupported);
}
