#include <UNISTD.H>
#include <SPAD/IOCTL.H>

#include <LINUX/FD.H>

#include <SPAD/IOC.H>

IOC_GEN_GET_MODE_DATA

static int fdgetprm(int h, unsigned long io, va_list va)
{
	struct floppy_struct *f = va_arg(va, struct floppy_struct *);
	return get_mode_data(h, IOCTL_BIO_FDGETPRM, 0, f, sizeof(struct floppy_struct));
}

static int f_sync(int h, unsigned long io, va_list va)
{
	return fsync(h);
}

static const struct ioc_entry ioc_table[] = {
	FDGETPRM,	1,	fdgetprm,
	FDFLUSH,	1,	f_sync,
	BLKFLSBUF,	1,	f_sync,
	0,		0,	NULL,
};

const struct ioc_entry * const IOC$TABLE = ioc_table;
