#ifndef __RAID_RAID_H
#define __RAID_RAID_H

#include <SPAD/AC.H>
#include <SPAD/DEV_KRNL.H>
#include <SPAD/SLAB.H>
#include <SPAD/BIO_KRNL.H>

typedef struct __raid RAID;
typedef struct __raid_device RAID_DEVICE;
typedef struct __raid_biorq RAID_BIORQ;
typedef struct __raid_biodesc RAID_BIODESC;

struct __raid_device {
	int h;
	RAID_BIORQ *rq;
	__sec_t sector;
};

extern char check_sizeof[sizeof(RAID_DEVICE) >= sizeof(char *) ? 1 : -1];

struct __raid {
	struct __slhead biorq;
	WQ biorq_wait;
	unsigned char ro;
	unsigned char type;
	unsigned read_request_size;
	unsigned write_request_size;
	unsigned physical_block_size;
	void *lnte;
	void *dlrq;
	char dev_name[__MAX_STR_LEN];
	void *dummy_biorq;
	PARTITIONS *p;
	unsigned n_devices;
	unsigned stripe;
	unsigned stripe_mod;	/* stripe multiplied by the number of devices */
	__u8 bsf_stripe;
	__u8 bsf_stripe_mod;
	RAID_DEVICE devices[1];
};

struct __raid_biodesc {
	BIODESC desc;
	RAID_BIODESC *next_to_free;
};

struct __raid_biorq {
	BIORQ b;
	RAID *raid;
	BIORQ *caller;
	RAID_BIODESC desc1;
};

#define TYPE_LINEAR	1
#define TYPE_0		2

void GET_DEVICE_PARAMS(int h, long *read_size, long *write_size, long *block_size);

/* RAIDCOM.C */

extern AST_STUB RAID_DONE;
void RAID_CTOR(struct __slhead *g, void *o);
void RAID_SPECIAL(RAID *raid, BIORQ *RQ);

/* RAIDLN.C */

__sec_t RAIDLN_INIT(RAID *raid);
extern const HANDLE_OPERATIONS RAIDLN_OPERATIONS;

/* RAID0.C */

__sec_t RAID0_INIT(RAID *raid);
extern const HANDLE_OPERATIONS RAID0_OPERATIONS;

#endif
