#include <SPAD/AC.H>
#include <SPAD/SYNC.H>
#include <SPAD/LIBC.H>
#include <SPAD/DEV_KRNL.H>
#include <SPAD/SLAB.H>
#include <MALLOC.H>
#include <STRING.H>
#include <VALUES.H>
#include <SPAD/BIO_KRNL.H>

#include "RAID.H"

static IO_STUB RAID0_FN;

const HANDLE_OPERATIONS RAID0_OPERATIONS = {
	SPL_X(SPL_RAID),
	KERNEL$NO_VSPACE_GET,
	KERNEL$NO_VSPACE_PUT,
	KERNEL$NO_VSPACE_MAP,
	KERNEL$NO_VSPACE_DMALOCK,
	KERNEL$NO_VSPACE_DMA64LOCK,
	KERNEL$NO_VSPACE_PHYSLOCK,
	KERNEL$NO_VSPACE_GET_PAGEIN_RQ,
	KERNEL$NO_VSPACE_GET_PAGE,
	KERNEL$NO_VSPACE_SWAP_OP,
	NULL,			/* clone */
	BIO$LOOKUP_PARTITION,	/* lookup */
	NULL,			/* create */
	NULL,			/* delete */
	NULL,			/* rename */
	NULL,			/* lookup_io */
	BIO$INSTANTIATE_PARTITION,	/* instantiate */
	NULL,			/* leave */
	BIO$DETACH,		/* detach */
	NULL,			/* close */
	BIO$READ,		/* READ */
	BIO$WRITE,		/* WRITE */
	BIO$AREAD,		/* AREAD */
	BIO$AWRITE,		/* AWRITE */
	BIO$IOCTL,		/* IOCTL */
	RAID0_FN,		/* BIO */
	KERNEL$NO_OPERATION,	/* PKTIO */
};

static DECL_IOCALL(RAID0_FN, SPL_RAID, BIORQ)
{
	RAID *raid;
	RAID_BIORQ *rq;
	__usec_t rq_sec;
	unsigned stripe_off;
	unsigned dev_n;
	unsigned left;
	HANDLE *h = RQ->handle;
	if (__unlikely(h->op != &RAID0_OPERATIONS)) RETURN_IORQ_LSTAT(RQ, KERNEL$WAKE_BIO);
	SWITCH_PROC_ACCOUNT(RQ->proc, SPL_X(SPL_RAID));
	RQ->tmp2 = 0;	/* future status */
	RQ->tmp3 = 1;	/* number of outstanding requests */
	raid = ((PARTITION *)h->fnode)->dev;
	if (__unlikely(RQ->flags & (raid->ro | BIO_FLUSH | ~BIO_FLAG_MASK))) {
		RAID_SPECIAL(raid, RQ);
		RETURN;
	}
	BIO_TRANSLATE_PARTITION;
	/*__debug_printf("IO: %LX , %X , %X\n", RQ->sec, RQ->nsec, RQ->flags);*/
	if (__likely((__s8)raid->bsf_stripe_mod >= 0)) {
		rq_sec = (__usec_t)RQ->sec >> raid->bsf_stripe_mod;
		stripe_off = (unsigned)RQ->sec & (raid->stripe_mod - 1);
	} else if (__likely(!(RQ->sec & ~(__sec_t)MAXUINT))) {
		unsigned rs = RQ->sec;
		stripe_off = rs % raid->stripe_mod;
		rq_sec = rs / raid->stripe_mod;
	} else {
		stripe_off = (__usec_t)RQ->sec % raid->stripe_mod;
		rq_sec = (__usec_t)RQ->sec / raid->stripe_mod;
	}
	if (__likely((__s8)raid->bsf_stripe >= 0)) {
		dev_n = stripe_off >> raid->bsf_stripe;
		stripe_off &= raid->stripe - 1;
		rq_sec <<= raid->bsf_stripe;
		rq_sec |= stripe_off;
	} else {
		dev_n = stripe_off / raid->stripe;
		stripe_off %= raid->stripe;
		rq_sec *= raid->stripe;
		rq_sec += stripe_off;
	}
	left = raid->stripe - stripe_off;
	rq = __slalloc(&raid->biorq);
	if (__unlikely(!rq)) {
		WQ_WAIT(&raid->biorq_wait, RQ, KERNEL$WAKE_BIO);
		RETURN;
	}
	rq_allocated:
	rq->b.sec = rq_sec;
	rq->caller = RQ;
	rq->b.proc = RQ->proc;
	rq->b.flags = RQ->flags;
	rq->b.fault_sec = -1;
	rq->b.fn = RAID_DONE;
	rq->b.h = raid->devices[dev_n].h;
	if (__likely(RQ->tmp3 == 1) && __likely(RQ->nsec <= left)) {
		rq->b.nsec = RQ->nsec;
		rq->b.desc = RQ->desc;
		RQ->nsec = 0;
		RETURN_IORQ(&rq->b, KERNEL$BIO);
	}
	raid->devices[dev_n].rq = rq;
	rq->b.nsec = 0;
	rq->b.desc = &rq->desc1.desc;
	rq->b.p = &rq->desc1;
#define rq_current_desc(rq)	((RAID_BIODESC *)(rq)->b.p)
	while (1) {
		RAID_BIODESC *new_desc;
		int diff;
		unsigned n = RQ->nsec;
		if (__unlikely(n > left)) n = left;
		memcpy(&rq_current_desc(rq)->desc.v, &RQ->desc->v, sizeof(VDESC));
		diff = (int)(rq_current_desc(rq)->desc.v.len >> BIO_SECTOR_SIZE_BITS) - (int)n;
		if (__unlikely(diff > 0)) {
			unsigned long dl = (unsigned long)n << BIO_SECTOR_SIZE_BITS;
			rq_current_desc(rq)->desc.v.len = dl;
			RQ->desc->v.ptr += dl;
			RQ->desc->v.len -= dl;
		} else {
			n += diff;
			RQ->desc = RQ->desc->next;
		}
		rq->b.nsec += n;
		RQ->nsec -= n;
		if (!RQ->nsec) break;
		RQ->sec += n;
		left -= n;
		if (__unlikely(!left)) {
			left = raid->stripe;
			rq_sec = rq->b.sec + (unsigned)rq->b.nsec;
			dev_n++;
			if (__unlikely(dev_n == raid->n_devices)) dev_n = 0;
			else rq_sec -= raid->stripe;
			rq = raid->devices[dev_n].rq;
			if (__likely(!rq)) {
				rq = __slalloc(&raid->biorq);
				if (__unlikely(!rq)) goto check_brk;
				raid->devices[dev_n].rq = rq;
				RQ->tmp3++;
				goto rq_allocated;
			}
		}
		new_desc = malloc(sizeof(RAID_BIODESC));
		if (__unlikely(!new_desc)) {
			check_brk:
			BIO_CHECK_REQUEST("RAID0_FN", RQ);
			break;
		}
		rq_current_desc(rq)->desc.next = &new_desc->desc;
		rq_current_desc(rq)->next_to_free = new_desc;
		rq->b.p = new_desc;
	}
	for (dev_n = 0; dev_n < raid->n_devices; dev_n++) if ((rq = raid->devices[dev_n].rq)) {
		rq_current_desc(rq)->desc.next = NULL;
		rq_current_desc(rq)->next_to_free = NULL;
		CALL_IORQ(&rq->b, KERNEL$BIO);
		raid->devices[dev_n].rq = NULL;
	}
#undef rq_current_desc
	RETURN;

	out:
	out2:
	RQ->status = -ERANGE;
	RETURN_BIO(RQ);
}

__COLD_ATTR__ __sec_t RAID0_INIT(RAID *raid)
{
	unsigned dev_n;
	int x;
	__usec_t size;
	__sec_t total;
	if (!raid->stripe) {
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "RAID: RAID0 MUST HAVE A STRIPE");
		return -EBADSYN;
	}
	size = -1;
	for (dev_n = 0; dev_n < raid->n_devices; dev_n++) {
		long rs, ws, bs;

		GET_DEVICE_PARAMS(raid->devices[dev_n].h, &rs, &ws, &bs);
		/*__debug_printf("dev_p: %x, %x, %x\n", rs, ws, bs);*/
		if (rs > 0 && rs < MAXINT && (!raid->read_request_size || rs < raid->read_request_size))
		/*if (rs > 0 && rs < MAXINT && rs > raid->read_request_size)*/
			raid->read_request_size = rs;
		if (ws > 0 && ws < MAXINT && ws > raid->write_request_size)
			raid->write_request_size = ws;
		if (bs > 0 && !(bs & (bs - 1))) {
			while (raid->stripe & (bs - 1))
				bs >>= 1;
			if (bs > raid->physical_block_size)
				raid->physical_block_size = bs;
		}

		if (raid->devices[dev_n].sector < size)
			size = raid->devices[dev_n].sector;
	}

	if (raid->read_request_size >= raid->stripe / 8) {
		if (raid->read_request_size < raid->stripe)
			raid->read_request_size = raid->stripe;
		x = raid->read_request_size * raid->n_devices;
		if (x / raid->n_devices == raid->read_request_size)
			raid->read_request_size = x;
	}

	if (raid->write_request_size >= raid->stripe / 8) {
		if (raid->write_request_size < raid->stripe)
			raid->write_request_size = raid->stripe;
		x = raid->write_request_size * raid->n_devices;
		if (x / raid->n_devices == raid->write_request_size)
			raid->write_request_size = x;
	}
	/*__debug_printf("params: %x, %x, %x\n", raid->read_request_size, raid->write_request_size, raid->physical_block_size);*/

	total = size * raid->n_devices;
	/*__debug_printf("%Lx %x -> %Lx, %Lx\n", size, raid->n_devices, total, total / raid->n_devices);*/
	if (total / raid->n_devices != size) {
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "RAID: COMBINED DEVICE IS TOO LARGE");
		return -EFBIG;
	}
	return total;
}
